/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity;

import earth.terrarium.pastel.entity.entity.BedrockFishingBobberEntity;
import earth.terrarium.pastel.entity.entity.BidentEntity;
import earth.terrarium.pastel.entity.entity.BidentMirrorImageEntity;
import earth.terrarium.pastel.entity.entity.BlockFlooderProjectile;
import earth.terrarium.pastel.entity.entity.DraconicTwinswordEntity;
import earth.terrarium.pastel.entity.entity.DragonTalonEntity;
import earth.terrarium.pastel.entity.entity.EggLayingWoolyPigEntity;
import earth.terrarium.pastel.entity.entity.EraserEntity;
import earth.terrarium.pastel.entity.entity.FireproofItemEntity;
import earth.terrarium.pastel.entity.entity.FloatBlockEntity;
import earth.terrarium.pastel.entity.entity.GlassArrowEntity;
import earth.terrarium.pastel.entity.entity.InkProjectileEntity;
import earth.terrarium.pastel.entity.entity.ItemProjectileEntity;
import earth.terrarium.pastel.entity.entity.KindlingCoughEntity;
import earth.terrarium.pastel.entity.entity.KindlingEntity;
import earth.terrarium.pastel.entity.entity.LagoonFishingBobberEntity;
import earth.terrarium.pastel.entity.entity.LightMineEntity;
import earth.terrarium.pastel.entity.entity.LightShardEntity;
import earth.terrarium.pastel.entity.entity.LightSpearEntity;
import earth.terrarium.pastel.entity.entity.LivingMarkerEntity;
import earth.terrarium.pastel.entity.entity.LizardEntity;
import earth.terrarium.pastel.entity.entity.MiningProjectileEntity;
import earth.terrarium.pastel.entity.entity.MoltenFishingBobberEntity;
import earth.terrarium.pastel.entity.entity.PhantomFrameEntity;
import earth.terrarium.pastel.entity.entity.PhantomGlowFrameEntity;
import earth.terrarium.pastel.entity.entity.PreservationTurretEntity;
import earth.terrarium.pastel.entity.entity.SeatEntity;
import earth.terrarium.pastel.entity.entity.ShootingStarEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PastelEntityTypes {
    private static final DeferredRegister<EntityType<?>> REGISTER = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"pastel");
    public static final DeferredHolder<EntityType<?>, EntityType<LivingMarkerEntity>> LIVING_MARKER = PastelEntityTypes.register("living_marker", 0, Integer.MAX_VALUE, false, EntityDimensions.scalable((float)0.0f, (float)0.0f), true, LivingMarkerEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<ShootingStarEntity>> SHOOTING_STAR = PastelEntityTypes.register("shooting_star", 15, 20, true, EntityDimensions.scalable((float)0.8f, (float)0.8f), true, ShootingStarEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<SeatEntity>> SEAT = PastelEntityTypes.register("seat", 8, 10, false, EntityDimensions.scalable((float)0.01f, (float)0.01f), true, SeatEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<FloatBlockEntity>> FLOAT_BLOCK = PastelEntityTypes.register("float_block", 10, 20, true, EntityDimensions.scalable((float)0.98f, (float)0.98f), true, FloatBlockEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<PhantomFrameEntity>> PHANTOM_FRAME = PastelEntityTypes.register("phantom_frame", 10, Integer.MAX_VALUE, false, EntityDimensions.scalable((float)0.5f, (float)0.5f), false, PhantomFrameEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<PhantomGlowFrameEntity>> GLOW_PHANTOM_FRAME = PastelEntityTypes.register("glow_phantom_frame", 10, Integer.MAX_VALUE, false, EntityDimensions.scalable((float)0.5f, (float)0.5f), false, PhantomGlowFrameEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<BlockFlooderProjectile>> BLOCK_FLOODER_PROJECTILE = PastelEntityTypes.register("block_flooder_projectile", 4, 10, true, EntityDimensions.scalable((float)0.25f, (float)0.25f), true, BlockFlooderProjectile::new);
    public static final DeferredHolder<EntityType<?>, EntityType<InkProjectileEntity>> INK_PROJECTILE = PastelEntityTypes.register("ink_projectile", 4, 10, true, EntityDimensions.scalable((float)0.3f, (float)0.3f), true, InkProjectileEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<LagoonFishingBobberEntity>> LAGOON_FISHING_BOBBER = PastelEntityTypes.register("lagoon_fishing_bobber", EntityType.Builder.of(LagoonFishingBobberEntity::new, (MobCategory)MobCategory.MISC).noSave().noSummon().fireImmune().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(5));
    public static final DeferredHolder<EntityType<?>, EntityType<MoltenFishingBobberEntity>> MOLTEN_FISHING_BOBBER = PastelEntityTypes.register("molten_fishing_bobber", EntityType.Builder.of(MoltenFishingBobberEntity::new, (MobCategory)MobCategory.MISC).noSave().noSummon().fireImmune().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(5));
    public static final DeferredHolder<EntityType<?>, EntityType<BedrockFishingBobberEntity>> BEDROCK_FISHING_BOBBER = PastelEntityTypes.register("bedrock_fishing_bobber", EntityType.Builder.of(BedrockFishingBobberEntity::new, (MobCategory)MobCategory.MISC).noSave().noSummon().fireImmune().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(5));
    public static final DeferredHolder<EntityType<?>, EntityType<FireproofItemEntity>> FIREPROOF_ITEM = PastelEntityTypes.register("fireproof_item", 6, 20, true, EntityDimensions.scalable((float)0.25f, (float)0.25f), true, FireproofItemEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<EggLayingWoolyPigEntity>> EGG_LAYING_WOOLY_PIG = PastelEntityTypes.register("egg_laying_wooly_pig", EntityType.Builder.of(EggLayingWoolyPigEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.3f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<GlassArrowEntity>> GLASS_ARROW = PastelEntityTypes.register("glass_arrow", EntityType.Builder.of(GlassArrowEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(1));
    public static final DeferredHolder<EntityType<?>, EntityType<MiningProjectileEntity>> MINING_PROJECTILE = PastelEntityTypes.register("mining_projectile", 4, 10, true, EntityDimensions.scalable((float)0.3f, (float)0.3f), true, MiningProjectileEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<BidentEntity>> BIDENT = PastelEntityTypes.register("bident", 4, 10, true, EntityDimensions.scalable((float)0.5f, (float)0.5f), true, BidentEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<BidentMirrorImageEntity>> BIDENT_MIRROR_IMAGE = PastelEntityTypes.register("bident_mirror_image", 4, 10, true, EntityDimensions.scalable((float)0.5f, (float)0.5f), true, BidentMirrorImageEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<LightShardEntity>> LIGHT_SHARD = PastelEntityTypes.register("light_shard", EntityType.Builder.of(LightShardEntity::new, (MobCategory)MobCategory.MISC).noSave().fireImmune().sized(0.75f, 0.75f).clientTrackingRange(6).updateInterval(1));
    public static final DeferredHolder<EntityType<?>, EntityType<LightSpearEntity>> LIGHT_SPEAR = PastelEntityTypes.register("light_spear", EntityType.Builder.of(LightSpearEntity::new, (MobCategory)MobCategory.MISC).noSave().fireImmune().sized(0.75f, 0.75f).clientTrackingRange(4).updateInterval(20));
    public static final DeferredHolder<EntityType<?>, EntityType<LightMineEntity>> LIGHT_MINE = PastelEntityTypes.register("light_mine", EntityType.Builder.of(LightMineEntity::new, (MobCategory)MobCategory.MISC).noSave().fireImmune().sized(0.75f, 0.75f).clientTrackingRange(4).updateInterval(20));
    public static final DeferredHolder<EntityType<?>, EntityType<PreservationTurretEntity>> PRESERVATION_TURRET = PastelEntityTypes.register("preservation_turret", EntityType.Builder.of(PreservationTurretEntity::new, (MobCategory)MobCategory.MONSTER).fireImmune().canSpawnFarFromPlayer().sized(1.0f, 1.0f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<LizardEntity>> LIZARD = PastelEntityTypes.register("lizard", EntityType.Builder.of(LizardEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 0.7f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<KindlingEntity>> KINDLING = PastelEntityTypes.register("kindling", EntityType.Builder.of(KindlingEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.0f).passengerAttachments(new float[]{0.5f}).clientTrackingRange(10).fireImmune());
    public static final DeferredHolder<EntityType<?>, EntityType<KindlingCoughEntity>> KINDLING_COUGH = PastelEntityTypes.register("kindling_cough", EntityType.Builder.of(KindlingCoughEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).fireImmune());
    public static final DeferredHolder<EntityType<?>, EntityType<EraserEntity>> ERASER = PastelEntityTypes.register("eraser", EntityType.Builder.of(EraserEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.3f, 0.3f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<ItemProjectileEntity>> ITEM_PROJECTILE = PastelEntityTypes.register("item_projectile", EntityType.Builder.of(ItemProjectileEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(6).updateInterval(20));
    public static final DeferredHolder<EntityType<?>, EntityType<DragonTalonEntity>> DRAGON_TALON = PastelEntityTypes.register("dragon_talon", 4, 10, true, EntityDimensions.scalable((float)0.5f, (float)0.5f), true, DragonTalonEntity::new);
    public static final DeferredHolder<EntityType<?>, EntityType<DraconicTwinswordEntity>> DRACONIC_TWINSWORD = PastelEntityTypes.register("draconic_twinsword", 6, 2, true, EntityDimensions.scalable((float)0.5f, (float)0.5f), true, DraconicTwinswordEntity::new);

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)EGG_LAYING_WOOLY_PIG.get(), EggLayingWoolyPigEntity.createEggLayingWoolyPigAttributes().build());
        event.put((EntityType)PRESERVATION_TURRET.get(), PreservationTurretEntity.createGuardianTurretAttributes().build());
        event.put((EntityType)LIZARD.get(), LizardEntity.createLizardAttributes().build());
        event.put((EntityType)KINDLING.get(), KindlingEntity.createKindlingAttributes().build());
        event.put((EntityType)ERASER.get(), EraserEntity.createEraserAttributes().build());
    }

    public static void register(IEventBus pastelBus) {
        pastelBus.addListener(PastelEntityTypes::registerAttributes);
        REGISTER.register(pastelBus);
    }

    public static <X extends Entity> DeferredHolder<EntityType<?>, EntityType<X>> register(String name, int trackingDistance, int updateIntervalTicks, boolean alwaysUpdateVelocity, EntityDimensions size, boolean fireImmune, EntityType.EntityFactory<X> factory) {
        return REGISTER.register(name, () -> {
            EntityType.Builder builder = EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)MobCategory.MISC).clientTrackingRange(trackingDistance).updateInterval(updateIntervalTicks).setShouldReceiveVelocityUpdates(alwaysUpdateVelocity).sized(size.width(), size.height());
            if (fireImmune) {
                builder.fireImmune();
            }
            return builder.build("pastel." + name);
        });
    }

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String id, EntityType.Builder<T> type) {
        return REGISTER.register(id, () -> type.build("pastel." + id));
    }
}

