/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.deeper_down;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.particle.client.FallingAshParticle;
import earth.terrarium.pastel.registries.PastelBiomes;
import earth.terrarium.pastel.sound.BiomeSoundInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HowlingSpireEffects {
    public static int spireTicks;
    public static int lastSpireTicks;
    private static boolean initialized;
    private static final long ASH_UPDATE_INTERVAL = 1600L;
    private static final double BASE_ASH_VELOCITY = 0.25;
    private static double targetAshVelocity;
    private static double lastAshVelocity;
    private static double ashScaleA;
    private static double ashScaleB;
    private static double ashScaleC;
    private static int ashSwitchTicks;
    private static int ashSpawns;
    private static Direction.Axis ashAxis;
    private static Minecraft client;

    public static void clientTick(ClientLevel world, Entity cameraEntity, Holder<Biome> biome) {
        if (client.isPaused()) {
            return;
        }
        lastSpireTicks = spireTicks;
        BiomeSoundInstance.update(biome);
        boolean inHowlingSpires = biome.is(PastelBiomes.HOWLING_SPIRES);
        if (inHowlingSpires) {
            if (spireTicks < 60) {
                ++spireTicks;
            }
        } else if (spireTicks > 0) {
            --spireTicks;
        }
        long time = world.getGameTime();
        RandomSource random = world.getRandom();
        double ashVelocity = targetAshVelocity;
        if (ashSwitchTicks < 50) {
            ashVelocity = Mth.clampedLerp((double)lastAshVelocity, (double)targetAshVelocity, (double)ashSwitchTicks);
            ++ashSwitchTicks;
        }
        if (time % 1600L == 0L || !initialized) {
            HowlingSpireEffects.updateAshEffects(random);
            FallingAshParticle.setTargetVelocity(ashVelocity);
            FallingAshParticle.setPrimaryAxis(ashAxis);
            FallingAshParticle.setAshScaleA(ashScaleA);
            FallingAshParticle.setAshScaleB(ashScaleB);
            FallingAshParticle.setAshScaleC(ashScaleC);
        }
        if (inHowlingSpires) {
            int maxAsh = ashSpawns / (PastelCommon.CONFIG.ReducedParticles ? 2 : 1);
            HowlingSpireEffects.spawnHowlingSpiresAsh(cameraEntity, maxAsh, random, world, biome);
        }
        initialized = true;
    }

    private static void updateAshEffects(RandomSource random) {
        Direction.Axis newAxis;
        ashSpawns = random.nextIntBetweenInclusive(5, 7);
        if ((double)random.nextFloat() < 0.125) {
            targetAshVelocity = Mth.clamp((double)(targetAshVelocity + (double)random.nextFloat() * 0.05 - 0.025), (double)0.025, (double)0.75);
            return;
        }
        if (random.nextFloat() < 0.95f) {
            return;
        }
        ashScaleA = 500.0 * (random.nextDouble() + 1.0) * (random.nextDouble() * 20.0) + 1000.0;
        ashScaleB = 100.0 * (random.nextDouble() + 1.0) * (random.nextDouble() * 10.0) + 250.0;
        ashScaleC = 20.0 * (random.nextDouble() + 1.0) * (random.nextDouble() * 5.0) + 100.0;
        Direction.Axis axis = newAxis = random.nextBoolean() ? Direction.Axis.X : Direction.Axis.Z;
        if (newAxis == ashAxis) {
            return;
        }
        targetAshVelocity = 0.25 * (random.nextDouble() * 0.5 + 0.5) * (double)(random.nextBoolean() ? -1 : 1);
        ashAxis = newAxis;
    }

    private static void spawnHowlingSpiresAsh(Entity cameraEntity, int maxAsh, RandomSource random, ClientLevel clientWorld, Holder<Biome> biome) {
        BlockPos pos;
        double z;
        double y;
        double x;
        int i;
        Vec3 camera = cameraEntity.position();
        int renderDistance = HowlingSpireEffects.getRenderRadius();
        int maxSpawnDistance = Math.min(96, renderDistance) * 2;
        for (i = 0; i < maxAsh; ++i) {
            x = camera.x() + (double)random.nextInt(maxSpawnDistance) - (double)((float)maxSpawnDistance / 2.0f);
            pos = new BlockPos((int)x, (int)(y = camera.y() + (double)random.nextInt(64) - 32.0), (int)(z = camera.z() + (double)random.nextInt(maxSpawnDistance) - (double)((float)maxSpawnDistance / 2.0f)));
            if (!clientWorld.getBlockState(pos).isAir()) continue;
            clientWorld.addParticle((ParticleOptions)PastelParticleTypes.FALLING_ASH, x, y, z, 0.0, 0.0, 0.0);
        }
        maxSpawnDistance /= 2;
        for (i = 0; i < maxAsh; ++i) {
            x = camera.x() + (double)random.nextInt(maxSpawnDistance) - (double)((float)maxSpawnDistance / 2.0f);
            pos = new BlockPos((int)x, (int)(y = camera.y() + (double)random.nextInt(29) - 8.0), (int)(z = camera.z() + (double)random.nextInt(maxSpawnDistance) - (double)((float)maxSpawnDistance / 2.0f)));
            if (!clientWorld.getBlockState(pos).isAir()) continue;
            clientWorld.addParticle((ParticleOptions)PastelParticleTypes.FALLING_ASH, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static int getRenderRadius() {
        return ((Integer)HowlingSpireEffects.client.options.renderDistance().get() + 1) * 16;
    }

    static {
        initialized = false;
        targetAshVelocity = 0.215;
        lastAshVelocity = 0.215;
        ashScaleA = 20000.0;
        ashScaleB = 2200.0;
        ashScaleC = 200.0;
        ashSwitchTicks = 50;
        ashAxis = Direction.Axis.X;
        client = Minecraft.getInstance();
    }
}

