/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.deeper_down;

import earth.terrarium.pastel.data_loaders.dimension.ColorGradingLoader;
import earth.terrarium.pastel.data_loaders.dimension.EnvDataLoader;
import earth.terrarium.pastel.deeper_down.ColorGrading;
import earth.terrarium.pastel.deeper_down.EnvironmentalData;
import earth.terrarium.pastel.deeper_down.EnvironmentalOverride;
import earth.terrarium.pastel.deeper_down.InterpMemory;
import earth.terrarium.pastel.registries.PastelBiomes;
import earth.terrarium.pastel.registries.PastelLevels;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import org.joml.Vector3f;

public class Environmental {
    private static final InterpMemory<float[]> GRADING_QUEUE = new InterpMemory();
    private static final InterpMemory<float[]> ENV_QUEUE = new InterpMemory();
    private static final InterpMemory<EnvironmentalOverride> OVERRIDE_QUEUE = new InterpMemory();
    private static final Minecraft client = Minecraft.getInstance();
    private static final Supplier<Float> delta = () -> Float.valueOf(client.getTimer().getGameTimeDeltaPartialTick(false));
    private static long envLoop;
    private static long overLoop;
    private static long over;
    private static boolean overActive;

    public static void tick(Entity entity) {
        Integer blending = (Integer)Environmental.client.options.biomeBlendRadius().get();
        ClientLevel level = Environmental.client.level;
        assert (level != null);
        envLoop = level.getGameTime() % 3L;
        overLoop = level.getGameTime() % 4L;
        if (envLoop == 0L) {
            Environmental.updateBiomeData(entity.blockPosition(), blending);
        }
        Environmental.updateOverrides(entity);
        if (GRADING_QUEUE.ready()) {
            ColorGrading.update(GRADING_QUEUE.last(), GRADING_QUEUE.current(), ((float)envLoop + delta.get().floatValue()) / 3.0f);
        }
    }

    private static void updateOverrides(Entity entity) {
        if (overActive && over < 20L) {
            ++over;
        } else if (!overActive && over > 0L) {
            --over;
        }
        if (overLoop != 0L) {
            return;
        }
        EnvironmentalOverride current = EnvironmentalOverride.get(entity);
        boolean bl = overActive = current != EnvironmentalOverride.INACTIVE;
        if (!overActive && over > 0L) {
            return;
        }
        OVERRIDE_QUEUE.accept(current);
    }

    private static void updateBiomeData(BlockPos center, int blendingRadius) {
        if (blendingRadius <= 0) {
            ResourceKey<Biome> biome = Environmental.findBiome(center);
            Environmental.processAndAcceptEnv(center, EnvDataLoader.DATA.getOrDefault(biome, EnvironmentalData.NOOP).asArray());
            GRADING_QUEUE.accept(ColorGradingLoader.DATA.getOrDefault(biome, ColorGrading.DEFAULT).asArray());
            return;
        }
        InterpolationStack envStack = new InterpolationStack(4);
        InterpolationStack gradingStack = new InterpolationStack(5);
        Cursor3D cursor = new Cursor3D(center.getX() - blendingRadius, center.getY() - blendingRadius, center.getZ() - blendingRadius, center.getX() + blendingRadius, center.getY() + blendingRadius, center.getZ() + blendingRadius);
        BlockPos.MutableBlockPos test = new BlockPos.MutableBlockPos();
        while (cursor.advance()) {
            test.set(cursor.nextX(), cursor.nextY(), cursor.nextZ());
            ResourceKey<Biome> biome = Environmental.findBiome((BlockPos)test);
            envStack.insert(EnvDataLoader.DATA.getOrDefault(biome, EnvironmentalData.NOOP).asArray());
            gradingStack.insert(ColorGradingLoader.DATA.getOrDefault(biome, ColorGrading.DEFAULT).asArray());
        }
        Environmental.processAndAcceptEnv(center, envStack.get());
        GRADING_QUEUE.accept(gradingStack.get());
    }

    private static void processAndAcceptEnv(BlockPos ref, float[] env) {
        assert (Environmental.client.level != null);
        if (Environmental.findBiome(ref).equals(PastelBiomes.BLACK_LANGAST)) {
            ENV_QUEUE.accept(env);
            return;
        }
        float depthDarkening = 0.0f;
        int topSpace = Environmental.client.level.getMaxBuildHeight() - ref.getY();
        depthDarkening += Mth.clampedLerp((float)0.334f, (float)0.0f, (float)((float)topSpace / 48.0f));
        int bottomSpace = ref.getY() - Environmental.client.level.getMinBuildHeight();
        float depthFog = Mth.clampedLerp((float)0.337f, (float)1.0f, (float)((float)bottomSpace / 48.0f));
        env[0] = Math.clamp(env[0] + (depthDarkening += Mth.clampedLerp((float)0.667f, (float)0.0f, (float)((float)bottomSpace / 64.0f))) / 2.0f, 0.0f, 1.0f);
        env[1] = Math.clamp(env[1] - depthDarkening / 3.0f, 0.01f, 1.0f);
        env[2] = env[2] - (1.0f - depthFog) * 2.0f;
        env[3] = env[3] * depthFog;
        env[2] = Math.min(env[2], env[3]);
        ENV_QUEUE.accept(env);
    }

    public static EnvironmentalData getEnvData() {
        if (!ENV_QUEUE.ready()) {
            return EnvironmentalData.NOOP;
        }
        float[] interpolated = new float[4];
        for (int i = 0; i < interpolated.length; ++i) {
            interpolated[i] = Mth.lerp((float)(((float)envLoop + delta.get().floatValue()) / 3.0f), (float)ENV_QUEUE.last()[i], (float)ENV_QUEUE.current()[i]);
        }
        float delta = Environmental.overDelta();
        float[] override = Environmental.processOverrides().dataOverride().asArray();
        interpolated[0] = interpolated[0] + Math.clamp(Mth.lerp((float)delta, (float)0.0f, (float)override[0]), -1.0f, 1.0f);
        interpolated[1] = interpolated[1] + Mth.lerp((float)delta, (float)0.0f, (float)override[1]);
        interpolated[2] = interpolated[2] + Mth.lerp((float)delta, (float)0.0f, (float)override[2]);
        interpolated[3] = interpolated[3] + Mth.lerp((float)delta, (float)0.0f, (float)override[3]);
        interpolated[0] = Math.clamp(interpolated[0], -0.1f, 1.0f);
        interpolated[1] = Math.clamp(interpolated[1], 0.0f, 1.0f);
        interpolated[2] = Math.max(interpolated[2], -10.0f);
        interpolated[3] = Math.max(interpolated[3], 0.125f);
        return EnvironmentalData.fromArray(interpolated);
    }

    public static void applyColor(float[] out) {
        EnvironmentalOverride override = Environmental.processOverrides();
        Vector3f color = override.color().colorMod();
        float blend = override.color().blend();
        float delta = Environmental.overDelta();
        out[0] = Mth.lerp((float)(delta * blend), (float)out[0], (float)color.x);
        out[1] = Mth.lerp((float)(delta * blend), (float)out[1], (float)color.y);
        out[2] = Mth.lerp((float)(delta * blend), (float)out[2], (float)color.z);
    }

    private static float overDelta() {
        float mutation = overActive ? (float)over + delta.get().floatValue() : (float)over - delta.get().floatValue();
        return Math.clamp(mutation / 20.0f, 0.0f, 1.0f);
    }

    private static EnvironmentalOverride processOverrides() {
        if (!OVERRIDE_QUEUE.ready()) {
            return EnvironmentalOverride.INACTIVE;
        }
        float[] cur = OVERRIDE_QUEUE.current().asArray();
        float[] last = OVERRIDE_QUEUE.last().asArray();
        float[] interpolated = new float[8];
        for (int i = 0; i < cur.length; ++i) {
            interpolated[i] = Mth.lerp((float)(((float)overLoop + delta.get().floatValue()) / 4.0f), (float)last[i], (float)cur[i]);
        }
        return EnvironmentalOverride.fromArray(interpolated);
    }

    public static float getNear(float original, boolean gentle) {
        float fogNear = Environmental.getEnvData().fogNear();
        if (gentle) {
            return original * (fogNear / 10.0f);
        }
        return fogNear * original;
    }

    public static float getFar(float original) {
        return Environmental.getEnvData().fogFar() * original;
    }

    private static ResourceKey<Biome> findBiome(BlockPos pos) {
        assert (Environmental.client.level != null);
        return Environmental.client.level.getBiome(pos).getKey();
    }

    public static State isActive() {
        if (Environmental.client.level == null) {
            return State.INACTIVE;
        }
        if (Environmental.client.level.dimension().equals(PastelLevels.DIMENSION_KEY)) {
            return State.ACTIVE;
        }
        if (overActive || over > 0L) {
            return State.PARTIAL;
        }
        return State.INACTIVE;
    }

    private static class InterpolationStack {
        private float[] stack;
        private int insets;

        public InterpolationStack(int size) {
            this.stack = new float[size];
        }

        public void insert(float[] inset) {
            for (int i = 0; i < inset.length; ++i) {
                int n = i;
                this.stack[n] = this.stack[n] + inset[i];
            }
            ++this.insets;
        }

        public void purge() {
            this.insets = 0;
            this.stack = new float[this.stack.length];
        }

        public float[] get() {
            float[] result = new float[this.stack.length];
            for (int i = 0; i < this.stack.length; ++i) {
                result[i] = this.stack[i] / (float)this.insets;
            }
            return result;
        }
    }

    public static enum State {
        INACTIVE(false),
        PARTIAL(true),
        ACTIVE(true);

        public final boolean overrides;

        private State(boolean overrides) {
            this.overrides = overrides;
        }

        public boolean force() {
            return this == ACTIVE;
        }
    }
}

