/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.deeper_down;

import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public final class DDOreVeinSampler {
    private static final int BLACKSLAG_LAYER_START_Y = -192;
    private static final float field_36620 = 0.4f;
    private static final int field_36621 = 20;
    private static final double field_36622 = 0.2;
    private static final float VEIN_LIMIT = 0.7f;
    private static final float field_36624 = 0.1f;
    private static final float field_36625 = 0.3f;
    private static final float field_36626 = 0.6f;
    private static final float RAW_ORE_BLOCK_CHANCE = 0.08f;
    private static final float ORE_OR_STONE_THRESHOLD = -0.15f;

    private DDOreVeinSampler() {
    }

    public static NoiseChunk.BlockStateFiller create(DensityFunction veinToggle, DensityFunction veinRidged, DensityFunction veinGap, PositionalRandomFactory randomDeriver) {
        return pos -> {
            double veinTypeSample = veinToggle.compute(pos);
            VeinType veinType = VeinType.getVeinTypeForSample(veinTypeSample);
            double absVeinTypeSample = Math.abs(veinTypeSample);
            int i = pos.blockY();
            int j = veinType.maxY - i;
            int k = i - veinType.minY;
            if (k >= 0 && j >= 0) {
                int l = Math.min(j, k);
                double f = Mth.clampedMap((double)l, (double)0.0, (double)20.0, (double)0.2, (double)0.0);
                if (absVeinTypeSample + f < 0.05) {
                    return null;
                }
                RandomSource random = randomDeriver.at(pos.blockX(), i, pos.blockZ());
                if (random.nextFloat() > 0.7f) {
                    return null;
                }
                if (veinRidged.compute(pos) >= 0.0) {
                    return null;
                }
                double g = Mth.clampedMap((double)absVeinTypeSample, (double)0.4f, (double)0.6f, (double)0.1f, (double)0.3f);
                if ((double)random.nextFloat() < g && veinGap.compute(pos) > (double)-0.15f) {
                    return random.nextFloat() < 0.08f ? veinType.rawOreBlock : (pos.blockY() < -192 ? veinType.blackslagOre : veinType.deepslateOre);
                }
                return veinType.stone;
            }
            return null;
        };
    }

    protected static enum VeinType {
        IRON(Blocks.IRON_ORE.defaultBlockState(), Blocks.IRON_ORE.defaultBlockState(), Blocks.RAW_IRON_BLOCK.defaultBlockState(), Blocks.STONE.defaultBlockState(), -256, -80),
        GOLD(Blocks.DEEPSLATE_GOLD_ORE.defaultBlockState(), ((Block)PastelBlocks.BLACKSLAG_GOLD_ORE.get()).defaultBlockState(), Blocks.RAW_GOLD_BLOCK.defaultBlockState(), Blocks.DIORITE.defaultBlockState(), -260, -128),
        DIAMOND(Blocks.DEEPSLATE_DIAMOND_ORE.defaultBlockState(), ((Block)PastelBlocks.BLACKSLAG_DIAMOND_ORE.get()).defaultBlockState(), Blocks.COAL_BLOCK.defaultBlockState(), Blocks.TUFF.defaultBlockState(), -316, -192),
        REDSTONE(Blocks.DEEPSLATE_REDSTONE_ORE.defaultBlockState(), ((Block)PastelBlocks.BLACKSLAG_REDSTONE_ORE.get()).defaultBlockState(), Blocks.REDSTONE_BLOCK.defaultBlockState(), Blocks.GRANITE.defaultBlockState(), -220, -80),
        LAPIS(Blocks.DEEPSLATE_LAPIS_ORE.defaultBlockState(), ((Block)PastelBlocks.BLACKSLAG_LAPIS_ORE.get()).defaultBlockState(), Blocks.LAPIS_BLOCK.defaultBlockState(), Blocks.ANDESITE.defaultBlockState(), -260, -128),
        EMERALD(Blocks.DEEPSLATE_EMERALD_ORE.defaultBlockState(), ((Block)PastelBlocks.BLACKSLAG_EMERALD_ORE.get()).defaultBlockState(), ((Block)PastelBlocks.BLACKSLAG.get()).defaultBlockState(), ((Block)PastelBlocks.BASAL_MARBLE.get()).defaultBlockState(), -316, -128);

        final BlockState deepslateOre;
        final BlockState blackslagOre;
        final BlockState rawOreBlock;
        final BlockState stone;
        final int minY;
        final int maxY;

        private VeinType(BlockState deepslateOre, BlockState blackslagOre, BlockState rawOreBlock, BlockState stone, int minY, int maxY) {
            this.deepslateOre = deepslateOre;
            this.blackslagOre = blackslagOre;
            this.rawOreBlock = rawOreBlock;
            this.stone = stone;
            this.minY = minY;
            this.maxY = maxY;
        }

        public static VeinType getVeinTypeForSample(double veinTypeSample) {
            return veinTypeSample > 0.3 ? REDSTONE : (veinTypeSample > 0.15 ? EMERALD : (veinTypeSample > 0.0 ? GOLD : (veinTypeSample < -0.45 ? DIAMOND : (veinTypeSample < -0.3 ? LAPIS : IRON))));
        }
    }
}

