/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.data;

import com.google.gson.JsonElement;
import earth.terrarium.pastel.blocks.decoration.CardinalFacingBlock;
import earth.terrarium.pastel.data.DatagenProxy;
import earth.terrarium.pastel.registries.DeferredRegistrar;
import earth.terrarium.pastel.registries.client.PastelTextureKeys;
import earth.terrarium.pastel.registries.client.PastelTextureMaps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PastelModelHelper {
    public static final DeferredRegistrar.Contextual<ItemModelGenerators> ITEM_MODEL_REGISTRAR = new DeferredRegistrar.Contextual(DatagenProxy.IS_DATAGEN);
    public static final DeferredRegistrar.Contextual<BlockModelGenerators> BLOCK_STATE_MODEL_REGISTRAR = new DeferredRegistrar.Contextual(DatagenProxy.IS_DATAGEN);

    public static void registerItemModel(ItemModelGenerators ctx, Item item) {
        PastelModelHelper.registerItemModel(ctx, item, "");
    }

    public static void registerItemModel(ItemModelGenerators ctx, Item item, String suffix) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), PastelTextureMaps.layer0(item, suffix), ctx.output);
    }

    public static void registerItemModel(ItemModelGenerators ctx, Item item, ModelTemplate model) {
        model.create(ModelLocationUtils.getModelLocation((Item)item), PastelTextureMaps.layer0(item, ""), ctx.output);
    }

    public static void registerLayeredItemModel(ItemModelGenerators ctx, Item item, ModelTemplate model, String suffix0, String suffix1) {
        model.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layered((ResourceLocation)TextureMapping.getItemTexture((Item)item, (String)suffix0), (ResourceLocation)TextureMapping.getItemTexture((Item)item, (String)suffix1)), ctx.output);
    }

    public static void registerLayeredItemModel(ItemModelGenerators ctx, Item item, ModelTemplate model, String suffix0, String suffix1, String suffix2) {
        model.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layered((ResourceLocation)TextureMapping.getItemTexture((Item)item, (String)suffix0), (ResourceLocation)TextureMapping.getItemTexture((Item)item, (String)suffix1), (ResourceLocation)TextureMapping.getItemTexture((Item)item, (String)suffix2)), ctx.output);
    }

    public static void registerLayeredItemModel(ItemModelGenerators ctx, Item item, ModelTemplate model, String suffix0, String suffix1, String suffix2, String suffix3) {
        model.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layered((ResourceLocation)TextureMapping.getItemTexture((Item)item, (String)suffix0), (ResourceLocation)TextureMapping.getItemTexture((Item)item, (String)suffix1), (ResourceLocation)TextureMapping.getItemTexture((Item)item, (String)suffix2)).put(PastelTextureKeys.LAYER3, TextureMapping.getItemTexture((Item)item, (String)suffix3)), ctx.output);
    }

    public static void registerBlockTexturedItemModel(ItemModelGenerators ctx, Block block) {
        PastelModelHelper.registerBlockTexturedItemModel(ctx, block, "");
    }

    public static void registerBlockTexturedItemModel(ItemModelGenerators ctx, Block block, String suffix) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)block.asItem()), PastelTextureMaps.layer0(block, suffix), ctx.output);
    }

    public static void registerParentedItemModel(ItemModelGenerators ctx, ItemLike item, Item parent) {
        PastelModelHelper.registerParentedItemModel(ctx, item, parent, "");
    }

    public static void registerParentedItemModel(ItemModelGenerators ctx, ItemLike item, Block parent) {
        PastelModelHelper.registerParentedItemModel(ctx, item, parent, "");
    }

    public static void registerParentedItemModel(ItemModelGenerators ctx, ItemLike item, Item parent, String suffix) {
        PastelModelHelper.registerParentedItemModel(ctx, item, ModelLocationUtils.getModelLocation((Item)parent, (String)suffix));
    }

    public static void registerParentedItemModel(ItemModelGenerators ctx, ItemLike item, Block parent, String suffix) {
        PastelModelHelper.registerParentedItemModel(ctx, item, ModelLocationUtils.getModelLocation((Block)parent, (String)suffix));
    }

    public static void registerParentedItemModel(ItemModelGenerators ctx, ItemLike item, ResourceLocation parentModelId) {
        ctx.output.accept(ModelLocationUtils.getModelLocation((Item)item.asItem()), new DelegatedModel(parentModelId));
    }

    public static BlockStateGenerator simpleMirroredBlockModel(BlockModelGenerators ctx, Block block) {
        return PastelModelHelper.createMirroredVariantsSupplier(block, TexturedModel.CUBE, TexturedModel.CUBE_MIRRORED, ctx.modelOutput);
    }

    public static BlockStateGenerator logBlockModel(BlockModelGenerators ctx, Block logBlock) {
        TextureMapping textureMap = PastelTextureMaps.sideEnd(logBlock, "", logBlock, "_top");
        ResourceLocation vertical = ModelTemplates.CUBE_COLUMN.create(logBlock, textureMap, ctx.modelOutput);
        ResourceLocation horizonal = ModelTemplates.CUBE_COLUMN_HORIZONTAL.create(logBlock, textureMap, ctx.modelOutput);
        return MultiVariantGenerator.multiVariant((Block)logBlock).with(PastelModelHelper.createAxisRotatedVariantMap(vertical, horizonal));
    }

    public static BlockStateGenerator woodBlockModel(BlockModelGenerators ctx, Block woodBlock, Block logBlock) {
        TextureMapping textureMap = PastelTextureMaps.sideEnd(logBlock, "", logBlock, "");
        ResourceLocation model = ModelTemplates.CUBE_COLUMN.create(woodBlock, textureMap, ctx.modelOutput);
        return MultiVariantGenerator.multiVariant((Block)woodBlock, (Variant)PastelModelHelper.createModelVariant(model)).with(PastelModelHelper.createAxisRotatedVariantMap());
    }

    public static BlockStateGenerator pottedPlantBlockModel(BlockModelGenerators ctx, FlowerPotBlock block, boolean tinted) {
        BlockModelGenerators.TintState tintType = tinted ? BlockModelGenerators.TintState.TINTED : BlockModelGenerators.TintState.NOT_TINTED;
        TextureMapping textureMap = TextureMapping.plant((Block)block.getPotted());
        ResourceLocation identifier = tintType.getCrossPot().create((Block)block, textureMap, ctx.modelOutput);
        return BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)identifier);
    }

    public static BlockStateGenerator glassPaneBlockModel(BlockModelGenerators ctx, Block glassPaneBlock, Block glassBlock) {
        TextureMapping textureMap = TextureMapping.pane((Block)glassBlock, (Block)glassPaneBlock);
        ResourceLocation post = ModelTemplates.STAINED_GLASS_PANE_POST.create(glassPaneBlock, textureMap, ctx.modelOutput);
        ResourceLocation side = ModelTemplates.STAINED_GLASS_PANE_SIDE.create(glassPaneBlock, textureMap, ctx.modelOutput);
        ResourceLocation sideAlt = ModelTemplates.STAINED_GLASS_PANE_SIDE_ALT.create(glassPaneBlock, textureMap, ctx.modelOutput);
        ResourceLocation noside = ModelTemplates.STAINED_GLASS_PANE_NOSIDE.create(glassPaneBlock, textureMap, ctx.modelOutput);
        ResourceLocation nosideAlt = ModelTemplates.STAINED_GLASS_PANE_NOSIDE_ALT.create(glassPaneBlock, textureMap, ctx.modelOutput);
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)glassPaneBlock.asItem()), TextureMapping.layer0((Block)glassBlock), ctx.modelOutput);
        return MultiPartGenerator.multiPart((Block)glassPaneBlock).with(Variant.variant().with(VariantProperties.MODEL, (Object)post)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)side)).with((Condition)Condition.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)side).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)sideAlt)).with((Condition)Condition.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)sideAlt).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)noside)).with((Condition)Condition.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)nosideAlt)).with((Condition)Condition.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)nosideAlt).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)noside).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270));
    }

    public static BlockFamily registerBlockFamily(BlockFamily family) {
        BLOCK_STATE_MODEL_REGISTRAR.defer(ctx -> ctx.family(family.getBaseBlock()).generateFor(family));
        return family;
    }

    public static BlockFamily registerBlockFamilyExceptBase(BlockFamily family, TexturedModel.Provider variantFactory) {
        BLOCK_STATE_MODEL_REGISTRAR.defer(ctx -> {
            TexturedModel texturedModel = variantFactory.get(family.getBaseBlock());
            BlockModelGenerators blockModelGenerators = ctx;
            Objects.requireNonNull(blockModelGenerators);
            BlockModelGenerators.BlockFamilyProvider texturePool = new BlockModelGenerators.BlockFamilyProvider(blockModelGenerators, texturedModel.getMapping());
            texturePool.fullBlock = ModelLocationUtils.getModelLocation((Block)family.getBaseBlock());
            texturePool.generateFor(family);
        });
        return family;
    }

    public static MultiVariantGenerator createVariantsSupplier(Block block, ResourceLocation ... modelIds) {
        return MultiVariantGenerator.multiVariant((Block)block, (Variant[])((Variant[])Arrays.stream(modelIds).map(modelId -> Variant.variant().with(VariantProperties.MODEL, modelId)).toArray(Variant[]::new)));
    }

    public static MultiVariantGenerator createVariantsSupplier(BlockModelGenerators ctx, Block block, TexturedModel.Provider factory) {
        return PastelModelHelper.createVariantsSupplier(block, factory.create(block, ctx.modelOutput));
    }

    public static MultiVariantGenerator createMirroredVariantsSupplier(Block block, TexturedModel.Provider factory, TexturedModel.Provider mirroredFactory, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector) {
        return MultiVariantGenerator.multiVariant((Block)block, (Variant[])new Variant[]{PastelModelHelper.createModelVariant(factory.create(block, modelCollector)), PastelModelHelper.createModelVariant(mirroredFactory.create(block, modelCollector))});
    }

    public static List<Variant> createHorizontalRotationVariantList(ResourceLocation modelId) {
        return List.of(PastelModelHelper.createModelVariant(modelId), PastelModelHelper.createModelVariant(modelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90), PastelModelHelper.createModelVariant(modelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180), PastelModelHelper.createModelVariant(modelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270));
    }

    public static PropertyDispatch createBooleanModelMap(BooleanProperty property, ResourceLocation trueModel, ResourceLocation falseModel) {
        return PropertyDispatch.property((Property)property).select((Comparable)Boolean.valueOf(false), PastelModelHelper.createModelVariant(falseModel)).select((Comparable)Boolean.valueOf(true), PastelModelHelper.createModelVariant(trueModel));
    }

    public static PropertyDispatch createCardinalFacingVariantMap() {
        return PropertyDispatch.property((Property)CardinalFacingBlock.CARDINAL_FACING).select((Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Boolean.valueOf(true), Variant.variant());
    }

    public static PropertyDispatch createAxisRotatedVariantMap() {
        return PropertyDispatch.property((Property)BlockStateProperties.AXIS).select((Comparable)Direction.Axis.X, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.Axis.Y, Variant.variant()).select((Comparable)Direction.Axis.Z, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90));
    }

    public static PropertyDispatch createAxisRotatedVariantMap(ResourceLocation verticalModelId, ResourceLocation horizontalModelId) {
        return PropertyDispatch.property((Property)BlockStateProperties.AXIS).select((Comparable)Direction.Axis.X, PastelModelHelper.createModelVariant(horizontalModelId).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.Axis.Y, PastelModelHelper.createModelVariant(verticalModelId)).select((Comparable)Direction.Axis.Z, PastelModelHelper.createModelVariant(horizontalModelId).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90));
    }

    public static PropertyDispatch createUpDefaultFacingVariantMap() {
        return PropertyDispatch.property((Property)BlockStateProperties.FACING).select((Comparable)Direction.DOWN, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.UP, Variant.variant()).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
    }

    public static PropertyDispatch createDownDefaultFacingVariantMap(ResourceLocation horizontalModelId, ResourceLocation verticalModelId) {
        return PropertyDispatch.property((Property)DirectionalBlock.FACING).select((Comparable)Direction.DOWN, PastelModelHelper.createModelVariant(verticalModelId)).select((Comparable)Direction.UP, PastelModelHelper.createModelVariant(verticalModelId).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.NORTH, PastelModelHelper.createModelVariant(horizontalModelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.SOUTH, PastelModelHelper.createModelVariant(horizontalModelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.WEST, PastelModelHelper.createModelVariant(horizontalModelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.EAST, PastelModelHelper.createModelVariant(horizontalModelId));
    }

    public static PropertyDispatch createNorthDefaultFacingVariantMap() {
        return PropertyDispatch.property((Property)BlockStateProperties.FACING).select((Comparable)Direction.DOWN, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.UP, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, Variant.variant()).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
    }

    public static PropertyDispatch createUpDefaultHorizontalFacingVariantMap() {
        return PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
    }

    public static PropertyDispatch createNorthDefaultHorizontalFacingVariantMap() {
        return PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.NORTH, Variant.variant()).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
    }

    public static PropertyDispatch createSouthDefaultHorizontalFacingVariantMap() {
        return PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.SOUTH, Variant.variant()).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270));
    }

    public static PropertyDispatch createWestDefaultHorizontalFacingVariantMap() {
        return PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.WEST, Variant.variant()).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180));
    }

    public static PropertyDispatch createEastDefaultHorizontalFacingVariantMap() {
        return PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.EAST, Variant.variant());
    }

    public static PropertyDispatch createUpNorthDefaultOrientationVariantMap() {
        return PropertyDispatch.property((Property)BlockStateProperties.ORIENTATION).select((Comparable)FrontAndTop.DOWN_NORTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)FrontAndTop.DOWN_SOUTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)FrontAndTop.DOWN_WEST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)FrontAndTop.DOWN_EAST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)FrontAndTop.UP_NORTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)FrontAndTop.UP_SOUTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)FrontAndTop.UP_WEST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)FrontAndTop.UP_EAST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)FrontAndTop.NORTH_UP, Variant.variant()).select((Comparable)FrontAndTop.SOUTH_UP, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)FrontAndTop.WEST_UP, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)FrontAndTop.EAST_UP, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
    }

    public static Variant createModelVariant(ResourceLocation modelId) {
        return Variant.variant().with(VariantProperties.MODEL, (Object)modelId);
    }

    public static Variant createModelVariant(Block block, String suffix) {
        return PastelModelHelper.createModelVariant(ModelLocationUtils.getModelLocation((Block)block, (String)suffix));
    }

    public static VariantProperties.Rotation getSouthDefaultRotation(Direction direction) {
        return switch (direction) {
            case Direction.WEST -> VariantProperties.Rotation.R90;
            case Direction.NORTH -> VariantProperties.Rotation.R180;
            case Direction.EAST -> VariantProperties.Rotation.R270;
            default -> VariantProperties.Rotation.R0;
        };
    }
}

