/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record MemoryComponent(int ticksToManifest, boolean spawnAsAdult, boolean brokenPromise, boolean unrecognizable) {
    public static final MemoryComponent DEFAULT = new MemoryComponent(-1, false, false, false);
    public static final Codec<MemoryComponent> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("ticks_to_manifest", (Object)-1).forGetter(MemoryComponent::ticksToManifest), (App)Codec.BOOL.optionalFieldOf("spawn_as_adult", (Object)false).forGetter(MemoryComponent::spawnAsAdult), (App)Codec.BOOL.optionalFieldOf("broken_promise", (Object)false).forGetter(MemoryComponent::brokenPromise), (App)Codec.BOOL.optionalFieldOf("unrecognizable", (Object)false).forGetter(MemoryComponent::unrecognizable)).apply((Applicative)i, MemoryComponent::new));
    public static final StreamCodec<ByteBuf, MemoryComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, MemoryComponent::ticksToManifest, (StreamCodec)ByteBufCodecs.BOOL, MemoryComponent::spawnAsAdult, (StreamCodec)ByteBufCodecs.BOOL, MemoryComponent::brokenPromise, (StreamCodec)ByteBufCodecs.BOOL, MemoryComponent::unrecognizable, MemoryComponent::new);

    public static class Builder {
        private int ticksToManifest;
        private boolean spawnAsAdult;
        private boolean brokenPromise;
        private boolean unrecognizable;

        public Builder(MemoryComponent component) {
            this.ticksToManifest = component.ticksToManifest;
            this.spawnAsAdult = component.spawnAsAdult;
            this.brokenPromise = component.brokenPromise;
            this.unrecognizable = component.unrecognizable;
        }

        public Builder ticksToManifest(int ticksToManifest) {
            this.ticksToManifest = ticksToManifest;
            return this;
        }

        public Builder spawnAsAdult(boolean spawnAsAdult) {
            this.spawnAsAdult = spawnAsAdult;
            return this;
        }

        public Builder brokenPromise(boolean brokenPromise) {
            this.brokenPromise = brokenPromise;
            return this;
        }

        public Builder unrecognizable() {
            this.unrecognizable = true;
            return this;
        }

        public MemoryComponent build() {
            return new MemoryComponent(this.ticksToManifest, this.spawnAsAdult, this.brokenPromise, this.unrecognizable);
        }
    }
}

