/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record BeverageComponent(long daysAged, int alcoholPercent, float thickness) implements TooltipProvider
{
    public static final BeverageComponent DEFAULT = new BeverageComponent(0L, 0, 0.0f);
    public static final Codec<BeverageComponent> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.LONG.optionalFieldOf("days_aged", (Object)0L).forGetter(BeverageComponent::daysAged), (App)Codec.INT.optionalFieldOf("alcohol_percent", (Object)0).forGetter(BeverageComponent::alcoholPercent), (App)Codec.FLOAT.optionalFieldOf("thickness", (Object)Float.valueOf(0.0f)).forGetter(BeverageComponent::thickness)).apply((Applicative)i, BeverageComponent::new));
    public static final StreamCodec<ByteBuf, BeverageComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, BeverageComponent::daysAged, (StreamCodec)ByteBufCodecs.VAR_INT, BeverageComponent::alcoholPercent, (StreamCodec)ByteBufCodecs.FLOAT, BeverageComponent::thickness, BeverageComponent::new);

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
        if (this.daysAged > 365L) {
            long ageInDays = this.daysAged % 365L;
            long ageInYears = Math.floorDiv(this.daysAged, 365);
            if (ageInDays == 0L) {
                tooltip.accept((Component)Component.translatable((String)"item.pastel.infused_beverage.tooltip.age_years", (Object[])new Object[]{ageInYears, this.alcoholPercent}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.accept((Component)Component.translatable((String)"item.pastel.infused_beverage.tooltip.age_composite", (Object[])new Object[]{ageInYears, ageInDays, this.alcoholPercent}).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.accept((Component)Component.translatable((String)"item.pastel.infused_beverage.tooltip.age", (Object[])new Object[]{this.daysAged, this.alcoholPercent}).withStyle(ChatFormatting.GRAY));
        }
    }
}

