/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.pages;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookAndCondition;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookRecipePage;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import earth.terrarium.pastel.api.block.GatedGuidebookPage;
import earth.terrarium.pastel.api.recipe.GatedRecipe;
import earth.terrarium.pastel.compat.modonomicon.unlock_conditions.RecipesLoadedAndUnlockedCondition;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BookGatedRecipePage<T extends GatedRecipe<?>>
extends BookRecipePage<T>
implements GatedGuidebookPage {
    private final ResourceLocation pageType;

    public BookGatedRecipePage(RecipeType<T> recipeType, ResourceLocation pageType, BookTextHolder title1, ResourceLocation recipeId1, BookTextHolder title2, ResourceLocation recipeId2, BookTextHolder text, String anchor, BookCondition condition) {
        super(recipeType, title1, recipeId1, title2, recipeId2, text, anchor, condition);
        this.pageType = pageType;
    }

    public static BookCondition getConditionWithRecipes(BookCondition condition, ResourceLocation recipeId1, ResourceLocation recipeId2) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        if (recipeId1 != null) {
            list.add(recipeId1);
        }
        if (recipeId2 != null) {
            list.add(recipeId2);
        }
        BookCondition[] conditions = new BookCondition[]{condition, new RecipesLoadedAndUnlockedCondition(null, list)};
        return new BookAndCondition(null, conditions);
    }

    public static <T extends GatedRecipe<?>> BookGatedRecipePage<T> fromJson(ResourceLocation entryId, ResourceLocation pageType, RecipeType<T> recipeType, JsonObject json, boolean supportsTwoRecipesOnOnePage, HolderLookup.Provider provider) {
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((ResourceLocation)entryId, (JsonObject)json.getAsJsonObject("condition"), (HolderLookup.Provider)provider) : new BookNoneCondition();
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        boolean skipRecipeUnlockCheck = GsonHelper.getAsBoolean((JsonObject)json, (String)"skip_recipe_unlock_check", (boolean)false);
        if (supportsTwoRecipesOnOnePage) {
            BookTextHolder title1 = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
            BookTextHolder title2 = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title2", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
            ResourceLocation recipeId1 = json.has("recipe_id") ? ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"recipe_id")) : null;
            ResourceLocation recipeId2 = json.has("recipe_id2") ? ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"recipe_id2")) : null;
            condition = skipRecipeUnlockCheck ? condition : BookGatedRecipePage.getConditionWithRecipes((BookCondition)condition, recipeId1, recipeId2);
            return new BookGatedRecipePage<T>(recipeType, pageType, title1, recipeId1, title2, recipeId2, text, anchor, (BookCondition)condition);
        }
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        ResourceLocation recipeId = json.has("recipe_id") ? ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"recipe_id")) : null;
        condition = skipRecipeUnlockCheck ? condition : BookGatedRecipePage.getConditionWithRecipes((BookCondition)condition, recipeId, null);
        return new BookGatedRecipePage<T>(recipeType, pageType, title, recipeId, BookTextHolder.EMPTY, null, text, anchor, (BookCondition)condition);
    }

    public static <T extends GatedRecipe<?>> BookGatedRecipePage<T> fromNetwork(ResourceLocation pageType, RecipeType<T> recipeType, RegistryFriendlyByteBuf buffer) {
        BookRecipePage.DataHolder common = BookRecipePage.commonFromNetwork((RegistryFriendlyByteBuf)buffer);
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork((RegistryFriendlyByteBuf)buffer);
        return new BookGatedRecipePage<T>(recipeType, pageType, common.title1(), common.recipeId1(), common.title2(), common.recipeId2(), common.text(), anchor, condition);
    }

    protected ItemStack getRecipeOutput(Level world, RecipeHolder<T> recipeEntry) {
        if (recipeEntry == null) {
            return ItemStack.EMPTY;
        }
        return ((GatedRecipe)recipeEntry.value()).getResultItem((HolderLookup.Provider)world.registryAccess());
    }

    public ResourceLocation getType() {
        return this.pageType;
    }
}

