/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.pages;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconCompat;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BookConfirmationButtonPage
extends BookTextPage {
    private final ResourceLocation checkedAdvancement;
    private BookTextHolder buttonText;
    private BookTextHolder confirmedButtonText;
    private final String confirmationString;

    public BookConfirmationButtonPage(BookTextHolder title, BookTextHolder text, boolean useMarkdownInTitle, boolean showTitleSeparator, String anchor, BookCondition condition, ResourceLocation checkedAdvancement, BookTextHolder buttonText, BookTextHolder confirmedButtonText, String confirmationString) {
        super(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition);
        this.checkedAdvancement = checkedAdvancement;
        this.buttonText = buttonText;
        this.confirmedButtonText = confirmedButtonText;
        this.confirmationString = confirmationString;
    }

    public static BookConfirmationButtonPage fromJson(ResourceLocation entryId, JsonObject json, HolderLookup.Provider provider) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        boolean useMarkdownInTitle = GsonHelper.getAsBoolean((JsonObject)json, (String)"use_markdown_title", (boolean)false);
        boolean showTitleSeparator = GsonHelper.getAsBoolean((JsonObject)json, (String)"show_title_separator", (boolean)true);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson((ResourceLocation)entryId, (JsonObject)json.getAsJsonObject("condition"), (HolderLookup.Provider)provider) : new BookNoneCondition();
        ResourceLocation checkedAdvancement = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"checked_advancement"));
        BookTextHolder buttonText = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"button_text", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        BookTextHolder confirmedButtonText = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"button_text_confirmed", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
        String confirmationString = GsonHelper.getAsString((JsonObject)json, (String)"confirmation", (String)"");
        return new BookConfirmationButtonPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, (BookCondition)condition, checkedAdvancement, buttonText, confirmedButtonText, confirmationString);
    }

    public static BookConfirmationButtonPage fromNetwork(RegistryFriendlyByteBuf buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        boolean useMarkdownInTitle = buffer.readBoolean();
        boolean showTitleSeparator = buffer.readBoolean();
        BookTextHolder text = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork((RegistryFriendlyByteBuf)buffer);
        ResourceLocation checkedAdvancement = buffer.readResourceLocation();
        BookTextHolder buttonText = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        BookTextHolder confirmedButtonText = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
        String confirmationString = buffer.readUtf();
        return new BookConfirmationButtonPage(title, text, useMarkdownInTitle, showTitleSeparator, anchor, condition, checkedAdvancement, buttonText, confirmedButtonText, confirmationString);
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.buttonText.hasComponent()) {
            this.buttonText = new BookTextHolder((Component)Component.translatable((String)this.buttonText.getKey()));
        }
        if (!this.confirmedButtonText.hasComponent()) {
            this.confirmedButtonText = new BookTextHolder((Component)Component.translatable((String)this.confirmedButtonText.getKey()));
        }
    }

    public ResourceLocation getCheckedAdvancement() {
        return this.checkedAdvancement;
    }

    public BookTextHolder getButtonText() {
        return this.buttonText;
    }

    public BookTextHolder getConfirmedButtonText() {
        return this.confirmedButtonText;
    }

    public String getConfirmationString() {
        return this.confirmationString;
    }

    public ResourceLocation getType() {
        return ModonomiconCompat.CONFIRMATION_BUTTON_PAGE;
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        super.toNetwork(buffer);
        buffer.writeResourceLocation(this.checkedAdvancement);
        this.buttonText.toNetwork(buffer);
        this.confirmedButtonText.toNetwork(buffer);
        buffer.writeUtf(this.confirmationString);
    }
}

