/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.client.pages;

import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.item.GemstoneColor;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconHelper;
import earth.terrarium.pastel.compat.modonomicon.client.pages.BookGatedRecipePageRenderer;
import earth.terrarium.pastel.compat.modonomicon.pages.BookGatedRecipePage;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BookPedestalCraftingPageRenderer
extends BookGatedRecipePageRenderer<PedestalRecipe, BookGatedRecipePage<PedestalRecipe>> {
    private static final ResourceLocation BACKGROUND_TEXTURE1 = PastelCommon.locate("textures/gui/modonomicon/pedestal_crafting1.png");
    private static final ResourceLocation BACKGROUND_TEXTURE2 = PastelCommon.locate("textures/gui/modonomicon/pedestal_crafting2.png");
    private static final ResourceLocation BACKGROUND_TEXTURE3 = PastelCommon.locate("textures/gui/modonomicon/pedestal_crafting3.png");
    private static final ResourceLocation BACKGROUND_TEXTURE4 = PastelCommon.locate("textures/gui/modonomicon/pedestal_crafting4.png");

    public BookPedestalCraftingPageRenderer(BookGatedRecipePage<PedestalRecipe> page) {
        super(page);
    }

    protected int getRecipeHeight() {
        return 110;
    }

    protected void drawRecipe(GuiGraphics drawContext, RecipeHolder<PedestalRecipe> recipeEntry, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        PedestalRecipe recipe = (PedestalRecipe)recipeEntry.value();
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        RenderSystem.enableBlend();
        drawContext.blit(this.getBackgroundTextureForTier(recipe.getTier()), recipeX - 2, recipeY - 2, 0.0f, 0.0f, 106, 97, 128, 256);
        this.renderTitle(drawContext, recipeY, second);
        this.parentScreen.renderItemStack(drawContext, recipeX + 78, recipeY + 22, mouseX, mouseY, recipe.getResultItem((HolderLookup.Provider)world.registryAccess()));
        switch (recipe.getTier()) {
            case COMPLEX: {
                this.drawGemstonePowderSlots(drawContext, recipe, recipe.getTier().gemstoneColors(), 3, recipeX, recipeY, mouseX, mouseY);
                break;
            }
            case ADVANCED: {
                this.drawGemstonePowderSlots(drawContext, recipe, recipe.getTier().gemstoneColors(), 12, recipeX, recipeY, mouseX, mouseY);
                break;
            }
            default: {
                this.drawGemstonePowderSlots(drawContext, recipe, recipe.getTier().gemstoneColors(), 22, recipeX, recipeY, mouseX, mouseY);
            }
        }
        List<IngredientStack> ingredients = recipe.getIngredientStacks();
        int wrap = recipe.getWidth();
        for (int i = 0; i < ingredients.size(); ++i) {
            ModonomiconHelper.renderIngredientStack(drawContext, this.parentScreen, recipeX + i % wrap * 19 + 3, recipeY + i / wrap * 19 + 3, mouseX, mouseY, ingredients.get(i));
        }
    }

    @Contract(pure=true)
    private ResourceLocation getBackgroundTextureForTier(@NotNull PedestalTier pedestalRecipeTier) {
        return switch (pedestalRecipeTier) {
            case PedestalTier.BASIC -> BACKGROUND_TEXTURE1;
            case PedestalTier.SIMPLE -> BACKGROUND_TEXTURE2;
            case PedestalTier.ADVANCED -> BACKGROUND_TEXTURE3;
            default -> BACKGROUND_TEXTURE4;
        };
    }

    private void drawGemstonePowderSlots(GuiGraphics drawContext, PedestalRecipe recipe, GemstoneColor @NotNull [] colors, int startX, int recipeX, int recipeY, int mouseX, int mouseY) {
        int h = 0;
        for (GemstoneColor color : colors) {
            int amount = recipe.getPowderInputs().getOrDefault(color, 0);
            if (amount > 0) {
                ItemStack stack = color.getPowder().getDefaultInstance();
                stack.setCount(amount);
                this.parentScreen.renderItemStack(drawContext, recipeX + startX + h * 19, recipeY + 72, mouseX, mouseY, stack);
            }
            ++h;
        }
    }
}

