/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.client.pages;

import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.fluid.FluidHolder;
import com.klikli_dev.modonomicon.fluid.NeoFluidHolder;
import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.crystallarieum.CrystallarieumBlock;
import earth.terrarium.pastel.compat.modonomicon.client.pages.BookGatedRecipePageRenderer;
import earth.terrarium.pastel.compat.modonomicon.pages.BookGatedRecipePage;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumCatalyst;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.state.BlockState;

public class BookCrystallarieumGrowingPageRenderer
extends BookGatedRecipePageRenderer<CrystallarieumRecipe, BookGatedRecipePage<CrystallarieumRecipe>> {
    private static final ResourceLocation BACKGROUND_TEXTURE = PastelCommon.locate("textures/gui/modonomicon/crystallarieum.png");
    private static BookTextHolder catalystText;
    private BookTextHolder craftingTimeText1 = null;
    private BookTextHolder craftingTimeText2 = null;

    public BookCrystallarieumGrowingPageRenderer(BookGatedRecipePage<CrystallarieumRecipe> page) {
        super(page);
        ResourceLocation font = BookDataManager.Client.get().safeFont(((BookGatedRecipePage)this.page).getBook().getFont());
        if (catalystText == null) {
            catalystText = new BookTextHolder((Component)Component.translatable((String)"container.pastel.modonomicon.crystallarieum.catalyst").withStyle(s -> s.withFont(font)));
        }
        if (page.getRecipe1() != null) {
            this.craftingTimeText1 = new BookTextHolder((Component)Component.translatable((String)(((CrystallarieumRecipe)page.getRecipe1().value()).growsWithoutCatalyst() ? "container.pastel.rei.crystallarieum.crafting_time_per_stage_seconds_catalyst_optional" : "container.pastel.rei.crystallarieum.crafting_time_per_stage_seconds"), (Object[])new Object[]{((CrystallarieumRecipe)page.getRecipe1().value()).getSecondsPerGrowthStage()}).withStyle(s -> s.withFont(font)));
        }
        if (page.getRecipe2() != null) {
            this.craftingTimeText2 = new BookTextHolder((Component)Component.translatable((String)(((CrystallarieumRecipe)page.getRecipe2().value()).growsWithoutCatalyst() ? "container.pastel.rei.crystallarieum.crafting_time_per_stage_seconds_catalyst_optional" : "container.pastel.rei.crystallarieum.crafting_time_per_stage_seconds"), (Object[])new Object[]{((CrystallarieumRecipe)page.getRecipe2().value()).getSecondsPerGrowthStage()}).withStyle(s -> s.withFont(font)));
        }
    }

    protected int getRecipeHeight() {
        return 100;
    }

    protected void drawRecipe(GuiGraphics drawContext, RecipeHolder<CrystallarieumRecipe> recipeEntry, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        CrystallarieumRecipe recipe = (CrystallarieumRecipe)recipeEntry.value();
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        RenderSystem.enableBlend();
        this.renderTitle(drawContext, recipeY += 2, second);
        int startX = 26;
        int offsetPerReagent = 18;
        Ingredient ingredient = recipe.getIngredientStack();
        this.parentScreen.renderIngredient(drawContext, recipeX + startX, recipeY + 5, mouseX, mouseY, ingredient);
        this.parentScreen.renderFluidStack(drawContext, recipeX + startX - offsetPerReagent - 4, recipeY + 5, mouseX, mouseY, (FluidHolder)new NeoFluidHolder(recipe.getFluidMedium()));
        drawContext.blit(BACKGROUND_TEXTURE, recipeX + startX - offsetPerReagent - 7, recipeY + 1, 0.0f, 0.0f, 53, 25, 128, 128);
        Iterator<BlockState> it = recipe.getGrowthStages().iterator();
        BlockState growthState = it.next();
        this.parentScreen.renderItemStack(drawContext, recipeX + startX + offsetPerReagent, recipeY - 1, mouseX, mouseY, growthState.getBlock().asItem().getDefaultInstance());
        int x = 0;
        while (it.hasNext()) {
            this.parentScreen.renderItemStack(drawContext, recipeX + 62 + offsetPerReagent * x, recipeY + 4, mouseX, mouseY, it.next().getBlock().asItem().getDefaultInstance());
            ++x;
        }
        this.parentScreen.renderItemStack(drawContext, recipeX + startX + offsetPerReagent, recipeY + 8, mouseX, mouseY, ((CrystallarieumBlock)PastelBlocks.CRYSTALLARIEUM.get()).asStackWithColor(recipe.getInkColor()));
        this.renderBookTextHolder(drawContext, catalystText, 0, 42, 124);
        this.renderBookTextHolder(drawContext, second ? this.craftingTimeText2 : this.craftingTimeText1, 0, 82, 124);
        x = 0;
        recipeY += 4;
        for (CrystallarieumCatalyst catalyst : recipe.getCatalysts()) {
            int offsetX = recipeX + startX + offsetPerReagent * x;
            this.parentScreen.renderIngredient(drawContext, recipeX + startX + offsetPerReagent * x, recipeY + 27, mouseX, mouseY, catalyst.ingredient());
            RenderSystem.enableBlend();
            int offset = 0;
            float accel = catalyst.growthAccelerationMod();
            if ((double)accel > 0.2) {
                if (accel >= 5.0f) {
                    offset = 28;
                } else if (accel > 1.0f) {
                    offset = 21;
                } else if (accel == 1.0f) {
                    offset = 14;
                } else if (accel < 1.0f) {
                    offset = 7;
                }
            }
            drawContext.blit(BACKGROUND_TEXTURE, offsetX + 5, recipeY + 45, 7, 7, (float)(70 + offset), 0.0f, 7, 7, 128, 128);
            float drain = catalyst.inkConsumptionMod();
            if (drain >= 5.0f) {
                offset = 0;
            } else if (drain > 1.0f) {
                offset = 7;
            } else if (drain == 1.0f) {
                offset = 14;
            } else if ((double)drain < 0.2) {
                offset = 28;
            } else if (drain < 1.0f) {
                offset = 21;
            }
            drawContext.blit(BACKGROUND_TEXTURE, offsetX + 5, recipeY + 54, 7, 7, (float)(70 + offset), 7.0f, 7, 7, 128, 128);
            float chance = catalyst.consumeChancePerSecond();
            if ((double)chance >= 0.25) {
                offset = 0;
            } else if ((double)chance < 1.0E-4) {
                offset = 28;
            } else if ((double)chance <= 0.02) {
                offset = 21;
            } else if ((double)chance < 0.05) {
                offset = 14;
            } else if ((double)chance < 0.25) {
                offset = 7;
            }
            drawContext.blit(BACKGROUND_TEXTURE, offsetX + 5, recipeY + 63, 7, 7, (float)(70 + offset), 14.0f, 7, 7, 128, 128);
            ++x;
        }
    }
}

