/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.client.pages;

import com.cmdpro.databank.DatabankUtils;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.page.BookTextPageRenderer;
import earth.terrarium.pastel.compat.modonomicon.pages.BookConfirmationButtonPage;
import earth.terrarium.pastel.networking.c2s_payloads.GuidebookConfirmationButtonPressedPayload;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class BookConfirmationButtonPageRenderer
extends BookTextPageRenderer {
    public BookConfirmationButtonPageRenderer(BookTextPage page) {
        super(page);
    }

    public boolean isConfirmed() {
        BookPage bookPage = this.page;
        if (!(bookPage instanceof BookConfirmationButtonPage)) {
            return false;
        }
        BookConfirmationButtonPage confirmationPage = (BookConfirmationButtonPage)bookPage;
        return DatabankUtils.hasAdvancement((Player)this.mc.player, (ResourceLocation)confirmationPage.getCheckedAdvancement());
    }

    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        BookPage bookPage = this.page;
        if (!(bookPage instanceof BookConfirmationButtonPage)) {
            return;
        }
        BookConfirmationButtonPage confirmationPage = (BookConfirmationButtonPage)bookPage;
        super.onBeginDisplayPage(parentScreen, left, top);
        boolean completed = this.isConfirmed();
        BookTextHolder buttonText = completed ? confirmationPage.getConfirmedButtonText() : confirmationPage.getButtonText();
        Button button = Button.builder((Component)buttonText.getComponent(), this::confirmationButtonClicked).size(112, 20).pos(2, 152).build();
        button.active = !completed;
        this.addButton(button);
    }

    protected void confirmationButtonClicked(Button button) {
        BookPage bookPage = this.page;
        if (!(bookPage instanceof BookConfirmationButtonPage)) {
            return;
        }
        BookConfirmationButtonPage confirmationPage = (BookConfirmationButtonPage)bookPage;
        PacketDistributor.sendToServer((CustomPacketPayload)new GuidebookConfirmationButtonPressedPayload(confirmationPage.getConfirmationString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        button.setMessage(confirmationPage.getConfirmedButtonText().getComponent());
        BookGuiManager.get().openEntry(((BookTextPage)this.page).getBook().getId(), ((BookTextPage)this.page).getParentEntry().getId(), ((BookTextPage)this.page).getPageNumber());
    }
}

