/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.client.pages;

import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.compat.modonomicon.client.pages.BookGatedRecipePageRenderer;
import earth.terrarium.pastel.compat.modonomicon.pages.BookGatedRecipePage;
import earth.terrarium.pastel.recipe.cinderhearth.CinderhearthRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class BookCinderhearthSmeltingPageRenderer
extends BookGatedRecipePageRenderer<CinderhearthRecipe, BookGatedRecipePage<CinderhearthRecipe>> {
    private static final ResourceLocation BACKGROUND_TEXTURE = PastelCommon.locate("textures/gui/modonomicon/cinderhearth.png");
    private List<BookTextHolder> chanceTexts1 = null;
    private List<BookTextHolder> chanceTexts2 = null;

    public BookCinderhearthSmeltingPageRenderer(BookGatedRecipePage<CinderhearthRecipe> page) {
        super(page);
    }

    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        if (this.chanceTexts1 == null && ((BookGatedRecipePage)this.page).getRecipe1() != null) {
            this.chanceTexts1 = this.createChanceTexts((CinderhearthRecipe)((BookGatedRecipePage)this.page).getRecipe1().value());
        }
        if (this.chanceTexts2 == null && ((BookGatedRecipePage)this.page).getRecipe2() != null) {
            this.chanceTexts2 = this.createChanceTexts((CinderhearthRecipe)((BookGatedRecipePage)this.page).getRecipe2().value());
        }
    }

    private List<BookTextHolder> createChanceTexts(CinderhearthRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return null;
        }
        ResourceLocation font = BookDataManager.Client.get().safeFont(((BookGatedRecipePage)this.page).getBook().getFont());
        ArrayList<BookTextHolder> chanceTexts = new ArrayList<BookTextHolder>();
        List<Tuple<ItemStack, Float>> possibleOutputs = recipe.getResultsWithChance();
        int chanceTextIndex = 0;
        for (Tuple<ItemStack, Float> possibleOutput : possibleOutputs) {
            if (!(((Float)possibleOutput.getB()).floatValue() < 1.0f)) continue;
            if (chanceTexts.size() < chanceTextIndex + 1) {
                chanceTexts.add(new BookTextHolder((Component)Component.literal((String)String.format("%f.2%%", Float.valueOf(((Float)possibleOutput.getB()).floatValue() * 100.0f))).withStyle(s -> s.withFont(font))));
            }
            ++chanceTextIndex;
        }
        return chanceTexts;
    }

    protected int getRecipeHeight() {
        return 54;
    }

    protected void drawRecipe(GuiGraphics drawContext, RecipeHolder<CinderhearthRecipe> recipeEntry, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        CinderhearthRecipe recipe = (CinderhearthRecipe)recipeEntry.value();
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        RenderSystem.enableBlend();
        List<Tuple<ItemStack, Float>> possibleOutputs = recipe.getResultsWithChance();
        recipeX = Math.max(recipeX, recipeX + 26 - possibleOutputs.size() * 10);
        int backgroundTextureWidth = 34 + possibleOutputs.size() * 24;
        drawContext.blit(BACKGROUND_TEXTURE, recipeX - 1, recipeY - 2, 0.0f, 0.0f, backgroundTextureWidth, 45, 128, 128);
        this.renderTitle(drawContext, recipeY, second);
        IngredientStack ingredientStack = recipe.getIngredientStacks().getFirst();
        this.parentScreen.renderIngredient(drawContext, recipeX + 2, recipeY + 7, mouseX, mouseY, ingredientStack.getIngredient(), ingredientStack.getCount());
        this.parentScreen.renderItemStack(drawContext, recipeX + 21, recipeY + 26, mouseX, mouseY, recipe.getToastSymbol());
        int chanceTextIndex = 0;
        for (int i = 0; i < possibleOutputs.size(); ++i) {
            List<BookTextHolder> chance;
            Tuple<ItemStack, Float> possibleOutput = possibleOutputs.get(i);
            int x = recipeX + 37 + i * 23;
            this.parentScreen.renderItemStack(drawContext, x, recipeY + 6, mouseX, mouseY, (ItemStack)possibleOutput.getA());
            if (!(((Float)possibleOutput.getB()).floatValue() < 1.0f)) continue;
            List<BookTextHolder> list = chance = second ? this.chanceTexts2 : this.chanceTexts1;
            if (chance == null) continue;
            BookTextHolder chanceText = chance.get(chanceTextIndex);
            this.renderBookTextHolder(drawContext, chanceText, x, recipeY + 24, 124);
            ++chanceTextIndex;
        }
    }
}

