/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetTooltipHolder;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AnimatedTexturedWidget
extends Widget
implements WidgetTooltipHolder<AnimatedTexturedWidget> {
    protected final ResourceLocation texture;
    protected final int x;
    protected final int y;
    protected final int textureWidth;
    protected final int textureHeight;
    private final int animationCount;
    private final double animationDurationMS;
    private BiFunction<Integer, Integer, List<ClientTooltipComponent>> tooltipSupplier = (mouseX, mouseY) -> List.of();

    public AnimatedTexturedWidget(ResourceLocation texture, int x, int y, int textureWidth, int textureHeight, int animationDurationMS) {
        this.texture = texture;
        this.x = x;
        this.y = y;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.animationDurationMS = animationDurationMS;
        this.animationCount = textureHeight / textureWidth;
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.textureWidth, this.textureWidth);
    }

    public AnimatedTexturedWidget tooltip(BiFunction<Integer, Integer, List<ClientTooltipComponent>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        return this.tooltipSupplier.apply(mouseX, mouseY);
    }

    public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)draw);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.animationDurationMS > 0.0) {
            int index = Mth.ceil((double)((double)System.currentTimeMillis() / (this.animationDurationMS / (double)this.animationCount) % (double)this.animationCount));
            context.drawTexture(this.texture, this.x, this.y, 0, (float)this.textureWidth, (float)(index * this.textureWidth), this.textureWidth, this.textureWidth, this.textureWidth, this.textureHeight);
        } else {
            context.drawTexture(this.texture, this.x, this.y, 0, (float)this.textureWidth, (float)this.textureWidth, this.textureWidth, this.textureWidth, this.textureWidth, this.textureHeight);
        }
    }
}

