/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.compat.emi.GatedSpectrumEmiRecipe;
import earth.terrarium.pastel.compat.emi.PastelEmiRecipeCategories;
import earth.terrarium.pastel.inventories.PedestalScreen;
import earth.terrarium.pastel.recipe.pedestal.PastelGemstoneColor;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;

public class PedestalCraftingEmiRecipeGated
extends GatedSpectrumEmiRecipe<PedestalRecipe> {
    public PedestalCraftingEmiRecipeGated(PedestalRecipe recipe) {
        super(PastelEmiRecipeCategories.PEDESTAL_CRAFTING, recipe, 124, 90);
        this.inputs = PedestalCraftingEmiRecipeGated.getIngredients(recipe);
    }

    @Override
    public boolean isUnlocked() {
        Minecraft client = Minecraft.getInstance();
        return ((PedestalRecipe)this.recipe).getTier().hasUnlocked((Player)client.player) && super.isUnlocked();
    }

    private static List<EmiIngredient> getIngredients(PedestalRecipe recipe) {
        int i;
        int powderSlotCount = recipe.getTier().getPowderSlotCount();
        List<IngredientStack> ingredients = recipe.getIngredientStacks();
        int ingredientCount = ingredients.size();
        NonNullList list = NonNullList.withSize((int)(9 + powderSlotCount), (Object)EmiStack.EMPTY);
        for (i = 0; i < ingredientCount; ++i) {
            list.set(recipe.getGridSlotId(i), EmiIngredient.of(Arrays.stream(ingredients.get(i).getIngredient().getItems()).map(EmiStack::of).toList()));
        }
        for (i = 0; i < powderSlotCount; ++i) {
            PastelGemstoneColor color = PastelGemstoneColor.values()[i];
            int powderAmount = recipe.getPowderInputs().getOrDefault(color, 0);
            if (powderAmount <= 0) continue;
            list.set(9 + i, EmiStack.of((ItemLike)color.getPowder(), (long)powderAmount));
        }
        return list;
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        int powderSlotCount = ((PedestalRecipe)this.recipe).getTier().getPowderSlotCount();
        int gemstoneSlotStartX = 62 - powderSlotCount * 9;
        int gemstoneSlotTextureStartU = 88 - powderSlotCount * 9;
        ResourceLocation backgroundTexture = PedestalScreen.getBackgroundTextureForTier(((PedestalRecipe)this.recipe).getTier());
        widgets.addTexture(backgroundTexture, gemstoneSlotStartX, 59, 18 * powderSlotCount, 18, gemstoneSlotTextureStartU, 76);
        widgets.addTexture(backgroundTexture, 0, 0, 54, 54, 29, 18);
        widgets.addTexture(backgroundTexture, 90, 14, 26, 26, 122, 32);
        widgets.addTexture(backgroundTexture, 82, 38, 40, 16, 200, 0);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                widgets.addSlot((EmiIngredient)this.inputs.get(y * 3 + x), x * 18, y * 18).drawBack(false);
            }
        }
        for (int i = 0; i < powderSlotCount; ++i) {
            widgets.addSlot((EmiIngredient)this.inputs.get(9 + i), i * 18 + gemstoneSlotStartX, 59).drawBack(false);
        }
        if (((PedestalRecipe)this.recipe).isShapeless()) {
            widgets.addTexture(EmiTexture.SHAPELESS, 94, 0);
        }
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 90, 14).large(true).drawBack(false).recipeContext((EmiRecipe)this);
        widgets.addFillingArrow(60, 18, ((PedestalRecipe)this.recipe).getCraftingTime() * 50);
        widgets.addText(PedestalCraftingEmiRecipeGated.getCraftingTimeText(((PedestalRecipe)this.recipe).getCraftingTime(), ((PedestalRecipe)this.recipe).getExperience()), this.width / 2, 80, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }
}

