/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.pastel.compat.emi.FluidIngredientEmi;
import earth.terrarium.pastel.compat.emi.GatedSpectrumEmiRecipe;
import earth.terrarium.pastel.compat.emi.PastelEmiRecipeCategories;
import earth.terrarium.pastel.recipe.fusion_shrine.FusionShrineRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FusionShrineEmiRecipeGated
extends GatedSpectrumEmiRecipe<FusionShrineRecipe> {
    private final List<FormattedCharSequence> texts;

    public FusionShrineEmiRecipeGated(FusionShrineRecipe recipe) {
        super(PastelEmiRecipeCategories.FUSION_SHRINE, recipe, 138, 60);
        Minecraft client = Minecraft.getInstance();
        this.texts = recipe.getDescription().isPresent() ? client.font.split((FormattedText)recipe.getDescription().get(), this.width) : List.of();
        this.inputs = new ArrayList();
        this.inputs.add(FluidIngredientEmi.into(recipe.getFluid()));
        this.inputs.addAll(recipe.getIngredientStacks().stream().map(s -> EmiIngredient.of(s.getItems().map(EmiStack::of).toList())).toList());
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)this.getRegistryManager())));
    }

    @Override
    public int getDisplayHeight() {
        if (this.isUnlocked()) {
            return this.height + this.texts.size() * 10;
        }
        return super.getDisplayHeight();
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        int i;
        if (!((EmiIngredient)this.inputs.getFirst()).isEmpty()) {
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.FUSION_SHRINE_BASALT.get())), 10, 25).drawBack(false);
            widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 30, 25);
        } else {
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)PastelBlocks.FUSION_SHRINE_BASALT.get())), 20, 25).drawBack(false);
        }
        int startX = Math.max(-20, 20 - this.inputs.size() * 10);
        for (i = 1; i < this.inputs.size(); ++i) {
            widgets.addSlot((EmiIngredient)this.inputs.get(i), startX + i * 20, 0);
        }
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 90, 20).large(true).recipeContext((EmiRecipe)this);
        widgets.addFillingArrow(60, 25, ((FusionShrineRecipe)this.recipe).getCraftingTime() * 50);
        for (i = 0; i < this.texts.size(); ++i) {
            widgets.addText(this.texts.get(i), 0, 50 + i * 10, 0x3F3F3F, false);
        }
        widgets.addText(FusionShrineEmiRecipeGated.getCraftingTimeText(((FusionShrineRecipe)this.recipe).getCraftingTime(), ((FusionShrineRecipe)this.recipe).getExperience()), this.width / 2, 50 + this.texts.size() * 10, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }
}

