/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.botania;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import vazkii.botania.api.item.ManaDissolvable;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class LeastBlackLotusItem
extends Item
implements ManaDissolvable {
    public LeastBlackLotusItem(Item.Properties settings) {
        super(settings);
    }

    public void onDissolveTick(ManaPool manaPool, ItemEntity itemEntity) {
        if (manaPool.isFull() || manaPool.getCurrentMana() == 0) {
            return;
        }
        BlockPos pos = manaPool.getManaReceiverPos();
        if (!itemEntity.level().isClientSide) {
            manaPool.receiveMana(1);
            EntityHelper.shrinkItem((ItemEntity)itemEntity);
            XplatAbstractions.INSTANCE.sendToTracking((Entity)itemEntity, (BotaniaPacket)new BotaniaEffectPacket(EffectType.BLACK_LOTUS_DISSOLVE, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), new int[0]));
        }
        itemEntity.playSound(BotaniaSounds.blackLotus, 1.0f, 0.25f);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.least_black_lotus.tooltip").withStyle(ChatFormatting.GRAY));
    }
}

