/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AnimatedTexturedWidget
extends BurningFire {
    private final Rectangle bounds;
    private final ResourceLocation texture;
    private final int animationCount;
    private final int textureWidth;
    private final int textureHeight;
    private double animationDurationMS = -1.0;

    public AnimatedTexturedWidget(ResourceLocation texture, Rectangle bounds, int textureWidth, int textureHeight) {
        this.texture = texture;
        this.animationCount = textureHeight / textureWidth;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.bounds = new Rectangle(Objects.requireNonNull(bounds));
    }

    public double getAnimationDuration() {
        return this.animationDurationMS;
    }

    public void setAnimationDuration(double animationDurationMS) {
        this.animationDurationMS = animationDurationMS;
        if (this.animationDurationMS <= 0.0) {
            this.animationDurationMS = -1.0;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getAnimationDuration() > 0.0) {
            int index = Mth.ceil((double)((double)System.currentTimeMillis() / (this.animationDurationMS / (double)this.animationCount) % (double)this.animationCount));
            graphics.blit(this.texture, this.getX(), this.getY(), 0.0f, (float)(index * 16), this.textureWidth, this.textureWidth, this.textureWidth, this.textureHeight);
        } else {
            graphics.blit(this.texture, this.getX(), this.getY(), 0.0f, 0.0f, this.textureWidth, this.textureWidth, this.textureWidth, this.textureHeight);
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }
}

