/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.plugins.GatedDisplayCategory;
import earth.terrarium.pastel.compat.REI.plugins.SpiritInstillingDisplay;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SpiritInstillingCategory
extends GatedDisplayCategory<SpiritInstillingDisplay> {
    private static final EntryIngredient SPIRIT_INSTILLER = EntryIngredients.of((ItemLike)((ItemLike)PastelBlocks.SPIRIT_INSTILLER.get()));
    private static final EntryIngredient ITEM_BOWL_CALCITE = EntryIngredients.of((ItemLike)((ItemLike)PastelBlocks.ITEM_BOWL_CALCITE.get()));

    public CategoryIdentifier<SpiritInstillingDisplay> getCategoryIdentifier() {
        return PastelPlugins.SPIRIT_INSTILLER;
    }

    public Component getTitle() {
        return ((Block)PastelBlocks.SPIRIT_INSTILLER.get()).getName();
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)PastelBlocks.SPIRIT_INSTILLER.get()));
    }

    @Override
    public void setupWidgets(Point startPoint, Rectangle bounds, List<Widget> widgets, @NotNull SpiritInstillingDisplay display) {
        List inputs = display.getInputEntries();
        int ingredientSize = inputs.size();
        int startX = Math.max(0, 10 - ingredientSize * 10);
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + startX, startPoint.y + 1)).markInput().entries((Collection)inputs.get(1)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + startX + 20, startPoint.y + 1)).markInput().entries((Collection)inputs.get(0)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + startX + 40, startPoint.y + 1)).markInput().entries((Collection)inputs.get(2)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x, startPoint.y + 1 + 17)).entries((Collection)ITEM_BOWL_CALCITE).disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 20, startPoint.y + 1 + 17)).entries((Collection)SPIRIT_INSTILLER).disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 40, startPoint.y + 1 + 17)).entries((Collection)ITEM_BOWL_CALCITE).disableBackground());
        widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x + 60, startPoint.y + 1 + 9)).animationDurationTicks((double)display.craftingTime));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 95, startPoint.y + 1 + 9)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 95, startPoint.y + 1 + 9)).markOutput().disableBackground().entries((Collection)display.getOutputEntries().get(0)));
        Component text = SpiritInstillingCategory.getCraftingTimeText(display.craftingTime, display.experience);
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x - 10, startPoint.y + 1 + 39), (Component)text).leftAligned().color(0x3F3F3F).noShadow());
    }

    public int getDisplayHeight() {
        return 58;
    }
}

