/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import com.google.common.collect.Lists;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.plugins.GatedDisplayCategory;
import earth.terrarium.pastel.compat.REI.plugins.PedestalCraftingDisplay;
import earth.terrarium.pastel.inventories.PedestalScreen;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PedestalCraftingCategory
extends GatedDisplayCategory<PedestalCraftingDisplay> {
    public CategoryIdentifier<PedestalCraftingDisplay> getCategoryIdentifier() {
        return PastelPlugins.PEDESTAL_CRAFTING;
    }

    public ResourceLocation getIdentifier() {
        return PastelCommon.locate("pedestal_crafting");
    }

    public Component getTitle() {
        return Component.translatable((String)"container.pastel.rei.pedestal_crafting.title");
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)PastelBlocks.PEDESTAL_BASIC_AMETHYST.get()));
    }

    @Override
    public void setupWidgets(Point startPoint, Rectangle bounds, List<Widget> widgets, @NotNull PedestalCraftingDisplay display) {
        ResourceLocation backgroundTexture = PedestalScreen.getBackgroundTextureForTier(display.getTier());
        widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x + 60, startPoint.y + 1 + 18)).animationDurationTicks((double)display.craftingTime));
        int powderSlotCount = display.getTier().getPowderSlotCount();
        int gemstoneSlotStartX = startPoint.x + 58 - powderSlotCount * 9;
        int gemstoneSlotTextureU = 88 - powderSlotCount * 9;
        List input = display.getInputEntries();
        int gemstoneDustStartSlot = 9;
        ArrayList slots = Lists.newArrayList();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                slots.add(Widgets.createSlot((Point)new Point(startPoint.x + 1 + x * 18, startPoint.y + 2 + y * 18)).disableBackground().markInput().disableBackground().entries((Collection)input.get(y * 3 + x)));
            }
        }
        for (int i = 0; i < powderSlotCount; ++i) {
            slots.add(Widgets.createSlot((Point)new Point(gemstoneSlotStartX + 1 + i * 18, startPoint.y + 61)).disableBackground().markInput().entries((Collection)input.get(gemstoneDustStartSlot + i)));
        }
        widgets.addAll(slots);
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)backgroundTexture, (int)gemstoneSlotStartX, (int)(startPoint.y + 60), (float)gemstoneSlotTextureU, (float)76.0f, (int)(powderSlotCount * 18), (int)18));
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)backgroundTexture, (int)startPoint.x, (int)(startPoint.y + 1), (float)29.0f, (float)18.0f, (int)54, (int)54));
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)backgroundTexture, (int)(startPoint.x + 90), (int)(startPoint.y + 15), (float)122.0f, (float)32.0f, (int)26, (int)26));
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)backgroundTexture, (int)(startPoint.x + 82), (int)(startPoint.y + 39), (float)200.0f, (float)0.0f, (int)40, (int)16));
        Component text = PedestalCraftingCategory.getCraftingTimeText(display.craftingTime, display.experience);
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.getCenterX(), startPoint.y + 82), (Component)text).centered().color(0x3F3F3F).noShadow());
        if (display.shapeless) {
            widgets.add(Widgets.createShapelessIcon((Point)new Point(startPoint.x + 108, startPoint.y + 4)));
        }
        List results = display.getOutputEntries();
        EntryIngredient result = EntryIngredient.of((Iterable)((Iterable)results.get(0)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 95, startPoint.y + 20)).entries((Collection)result).disableBackground().markOutput());
    }

    public int getDisplayHeight() {
        return 100;
    }
}

