/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.compat.REI.PastelDisplay;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.REIHelper;
import earth.terrarium.pastel.recipe.fusion_shrine.FusionShrineRecipe;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class FusionShrineDisplay
extends PastelDisplay {
    protected final float experience;
    protected final int craftingTime;
    protected final Optional<Component> description;

    public FusionShrineDisplay(@NotNull RecipeHolder<FusionShrineRecipe> recipe) {
        super(recipe, FusionShrineDisplay.buildIngredients((FusionShrineRecipe)recipe.value()), ((FusionShrineRecipe)recipe.value()).getResultItem((HolderLookup.Provider)BasicDisplay.registryAccess()));
        this.experience = ((FusionShrineRecipe)recipe.value()).getExperience();
        this.craftingTime = ((FusionShrineRecipe)recipe.value()).getCraftingTime();
        this.description = ((FusionShrineRecipe)recipe.value()).getDescription();
    }

    private static List<EntryIngredient> buildIngredients(FusionShrineRecipe recipe) {
        List<EntryIngredient> inputs = REIHelper.toEntryIngredients(recipe.getIngredientStacks());
        inputs.add(0, REIHelper.ofFluidIngredient(recipe.getFluid()));
        return inputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return PastelPlugins.FUSION_SHRINE;
    }

    @Override
    public boolean isUnlocked() {
        Minecraft client = Minecraft.getInstance();
        return DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)FusionShrineRecipe.UNLOCK_IDENTIFIER) && super.isUnlocked();
    }

    public Optional<Component> getDescription() {
        return this.description;
    }
}

