/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.plugins.FusionShrineDisplay;
import earth.terrarium.pastel.compat.REI.plugins.GatedDisplayCategory;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FusionShrineCategory
extends GatedDisplayCategory<FusionShrineDisplay> {
    private static final EntryIngredient FUSION_SHRINE_BASALT = EntryIngredients.of((ItemLike)((ItemLike)PastelBlocks.FUSION_SHRINE_BASALT.get()));

    public CategoryIdentifier<FusionShrineDisplay> getCategoryIdentifier() {
        return PastelPlugins.FUSION_SHRINE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.pastel.fusion_shrine");
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)PastelBlocks.FUSION_SHRINE_BASALT.get()));
    }

    @Override
    public void setupWidgets(Point startPoint, Rectangle bounds, List<Widget> widgets, @NotNull FusionShrineDisplay display) {
        List inputs = display.getInputEntries();
        if (!((EntryIngredient)inputs.get(0)).equals((Object)EntryIngredients.of((Fluid)Fluids.EMPTY))) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 10, startPoint.y - 7 + 35)).entries((Collection)FUSION_SHRINE_BASALT).disableBackground());
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 30, startPoint.y - 7 + 35)).markInput().entries((Collection)inputs.get(0)));
        } else {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 20, startPoint.y - 7 + 35)).entries((Collection)FUSION_SHRINE_BASALT).disableBackground());
        }
        int ingredientSize = inputs.size() - 1;
        int startX = Math.max(-10, 10 - ingredientSize * 10);
        for (int i = 0; i < ingredientSize; ++i) {
            EntryIngredient currentIngredient = (EntryIngredient)inputs.get(i + 1);
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + startX + i * 20, startPoint.y - 7 + 9)).markInput().entries((Collection)currentIngredient));
        }
        widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x + 60, startPoint.y - 7 + 35)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 95, startPoint.y - 7 + 35)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 95, startPoint.y - 7 + 35)).markOutput().disableBackground().entries((Collection)display.getOutputEntries().get(0)));
        if (display.getDescription().isPresent()) {
            Component description = display.getDescription().get();
            widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x - 10, startPoint.y - 13 + 65), (Component)description).leftAligned().color(0x3F3F3F).noShadow());
        }
        Component text = FusionShrineCategory.getCraftingTimeText(display.craftingTime, display.experience);
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x - 10, startPoint.y - 13 + 75), (Component)text).leftAligned().color(0x3F3F3F).noShadow());
    }

    public int getDisplayHeight() {
        return 80;
    }
}

