/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.plugins.EnchanterDisplay;
import earth.terrarium.pastel.items.magic_items.KnowledgeGemItem;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import earth.terrarium.pastel.recipe.RecipeScaling;
import earth.terrarium.pastel.recipe.enchanter.EnchanterCraftingRecipe;
import earth.terrarium.pastel.recipe.enchanter.EnchantmentUpgradeRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class EnchantmentUpgradeDisplay
extends EnchanterDisplay {
    protected final Holder<Enchantment> enchantment;
    static final int XP_INDEX = 8;
    static final int OVERXP_INDEX = 9;
    static final int NORMAL_INDEX = 10;
    static final int OVERCHANT_INDEX = 11;
    final int levelCap;
    final int maxNormal;
    final Component transKey;
    final RecipeScaling.ScalingData itemScaling;
    final RecipeScaling.ScalingData xpScaling;
    EntryIngredient normalOutputs;
    EntryIngredient overchantOutputs;
    int index = 1;

    public EnchantmentUpgradeDisplay(@NotNull RecipeHolder<EnchantmentUpgradeRecipe> recipeEntry) {
        super((RecipeHolder<? extends GatedPastelRecipe<?>>)recipeEntry, EnchantmentUpgradeDisplay.buildIngredients((EnchantmentUpgradeRecipe)recipeEntry.value()), EnchantmentUpgradeDisplay.buildOutputs((EnchantmentUpgradeRecipe)recipeEntry.value()));
        EnchantmentUpgradeRecipe recipe = (EnchantmentUpgradeRecipe)recipeEntry.value();
        this.enchantment = recipe.getEnchantment();
        this.levelCap = recipe.getLevelCap();
        this.maxNormal = ((Enchantment)this.enchantment.value()).getMaxLevel();
        this.itemScaling = recipe.getItemScaling();
        this.xpScaling = recipe.getXpScaling();
        this.transKey = ((Enchantment)this.enchantment.value()).description().copy().withStyle(s -> {
            s.withItalic(Boolean.valueOf(true));
            s.withColor(5060181);
            return s;
        });
        this.fuck(recipe);
    }

    private static List<EntryIngredient> buildIngredients(EnchantmentUpgradeRecipe recipe) {
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
        Holder<Enchantment> enchant = recipe.getEnchantment();
        int levelCap = recipe.getLevelCap();
        int maxNormal = ((Enchantment)enchant.value()).getMaxLevel();
        for (int i = 0; i < 8; ++i) {
            inputs.add(EntryIngredients.of((ItemLike)recipe.getBulkItem(), (int)1));
        }
        ArrayList<ItemStack> xpNormal = new ArrayList<ItemStack>();
        ArrayList<ItemStack> xpOver = new ArrayList<ItemStack>();
        ArrayList<ItemStack> enchNormal = new ArrayList<ItemStack>();
        ArrayList<ItemStack> enchOver = new ArrayList<ItemStack>();
        for (int i = 1; i < levelCap; ++i) {
            ItemStack gem = KnowledgeGemItem.getKnowledgeDropStackWithXP(recipe.getXpScaling().apply(i), true);
            if (i < maxNormal) {
                EnchantmentUpgradeDisplay.appendBookStack(enchant, i, enchNormal);
                xpNormal.add(gem);
            }
            EnchantmentUpgradeDisplay.appendBookStack(enchant, i, enchOver);
            xpOver.add(gem);
        }
        inputs.add(EntryIngredients.ofItemStacks(xpNormal));
        inputs.add(EntryIngredients.ofItemStacks(xpOver));
        inputs.add(EntryIngredients.ofItemStacks(enchNormal));
        inputs.add(EntryIngredients.ofItemStacks(enchOver));
        return Collections.singletonList(EntryIngredients.ofItemStacks(enchOver));
    }

    private static List<EntryIngredient> buildOutputs(EnchantmentUpgradeRecipe recipe) {
        ArrayList<ItemStack> enchOver = new ArrayList<ItemStack>();
        int levelCap = recipe.getLevelCap();
        for (int i = 2; i <= levelCap; ++i) {
            EnchantmentUpgradeDisplay.appendBookStack(recipe.getEnchantment(), i, enchOver);
        }
        return Collections.singletonList(EntryIngredients.ofItemStacks(enchOver));
    }

    private void fuck(EnchantmentUpgradeRecipe recipe) {
        ArrayList<ItemStack> enchNormal = new ArrayList<ItemStack>();
        ArrayList<ItemStack> enchOver = new ArrayList<ItemStack>();
        for (int i = 2; i <= this.levelCap; ++i) {
            if (i <= this.maxNormal) {
                EnchantmentUpgradeDisplay.appendBookStack(recipe.getEnchantment(), i, enchNormal);
            }
            EnchantmentUpgradeDisplay.appendBookStack(recipe.getEnchantment(), i, enchOver);
        }
        this.normalOutputs = EntryIngredients.ofItemStacks(enchNormal);
        this.overchantOutputs = EntryIngredients.ofItemStacks(enchOver);
    }

    private static void appendBookStack(Holder<Enchantment> enchant, int i, ArrayList<ItemStack> enchIn) {
        ItemStack enchStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        builder.set(enchant, i);
        enchStack.set(DataComponents.STORED_ENCHANTMENTS, (Object)builder.toImmutable());
        enchIn.add(enchStack);
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return PastelPlugins.ENCHANTMENT_UPGRADE;
    }

    @Override
    public boolean isUnlocked() {
        Minecraft client = Minecraft.getInstance();
        return DatabankUtils.hasAdvancement((Player)client.player, (ResourceLocation)EnchanterCraftingRecipe.UNLOCK_IDENTIFIER) && super.isUnlocked();
    }
}

