/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.REI.plugins;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.crystallarieum.CrystallarieumBlock;
import earth.terrarium.pastel.compat.REI.PastelPlugins;
import earth.terrarium.pastel.compat.REI.plugins.CrystallarieumDisplay;
import earth.terrarium.pastel.compat.REI.plugins.GatedDisplayCategory;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumCatalyst;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CrystallarieumCategory
extends GatedDisplayCategory<CrystallarieumDisplay> {
    public static final ResourceLocation BACKGROUND_TEXTURE = PastelCommon.locate("textures/gui/modonomicon/crystallarieum.png");

    public CategoryIdentifier<CrystallarieumDisplay> getCategoryIdentifier() {
        return PastelPlugins.CRYSTALLARIEUM;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.pastel.crystallarieum");
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)PastelBlocks.CRYSTALLARIEUM.get()));
    }

    @Override
    public void setupWidgets(Point startPoint, Rectangle bounds, List<Widget> widgets, @NotNull CrystallarieumDisplay display) {
        EntryIngredient input = (EntryIngredient)display.getInputEntries().get(0);
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x - 2, startPoint.y + 1 + 8)).markInput().entries((Collection)input));
        ItemStack crystallarieumStack = ((CrystallarieumBlock)PastelBlocks.CRYSTALLARIEUM.get()).asStackWithColor(display.inkColor);
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 20, startPoint.y + 3 + 16)).entries((Collection)EntryIngredients.of((ItemStack)crystallarieumStack)).disableBackground());
        widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x + 39, startPoint.y + 1 + 8)).animationDurationTicks((double)display.secondsPerStage));
        Iterator<EntryIngredient> it = display.growthStages.iterator();
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 20, startPoint.y + 3)).markInput().entries((Collection)it.next()));
        int x = 0;
        while (it.hasNext()) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 66 + x * 20, startPoint.y + 1 + 8)).markInput().entries((Collection)it.next()));
            ++x;
        }
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x, startPoint.y + 1 + 42), (Component)Component.translatable((String)"container.pastel.rei.crystallarieum.catalyst")).leftAligned().color(0x3F3F3F).noShadow());
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x, startPoint.y + 1 + 58), (Component)Component.translatable((String)"container.pastel.rei.crystallarieum.accelerator")).leftAligned().color(0x3F3F3F).noShadow());
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x, startPoint.y + 1 + 68), (Component)Component.translatable((String)"container.pastel.rei.crystallarieum.ink_consumption")).leftAligned().color(0x3F3F3F).noShadow());
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x, startPoint.y + 1 + 78), (Component)Component.translatable((String)"container.pastel.rei.crystallarieum.used_up")).leftAligned().color(0x3F3F3F).noShadow());
        int i = 0;
        int startX = 46;
        int offsetPerReagent = 18;
        for (CrystallarieumCatalyst catalyst : display.catalysts) {
            int offsetX = startPoint.x + startX + offsetPerReagent * i;
            widgets.add((Widget)Widgets.createSlot((Point)new Point(offsetX, startPoint.y + 1 + 38)).markInput().entries((Collection)EntryIngredients.ofIngredient((Ingredient)catalyst.ingredient())));
            float growthAcceleration = catalyst.growthAccelerationMod();
            int offsetU = growthAcceleration == 1.0f ? 97 : (growthAcceleration >= 6.0f ? 85 : (growthAcceleration > 1.0f ? 67 : ((double)growthAcceleration <= 0.25 ? 79 : 73)));
            widgets.add(Widgets.createTexturedWidget((ResourceLocation)BACKGROUND_TEXTURE, (int)(offsetX + 5), (int)(startPoint.y + 1 + 59), (float)offsetU, (float)0.0f, (int)6, (int)6, (int)128, (int)128));
            float inkConsumption = catalyst.inkConsumptionMod();
            offsetU = inkConsumption == 1.0f ? 97 : (inkConsumption >= 8.0f ? 85 : (inkConsumption > 1.0f ? 67 : ((double)inkConsumption <= 0.25 ? 79 : 73)));
            widgets.add(Widgets.createTexturedWidget((ResourceLocation)BACKGROUND_TEXTURE, (int)(offsetX + 5), (int)(startPoint.y + 1 + 69), (float)offsetU, (float)6.0f, (int)6, (int)6, (int)128, (int)128));
            float consumeChance = catalyst.consumeChancePerSecond();
            offsetU = consumeChance == 0.0f ? 97 : ((double)consumeChance >= 0.2 ? 85 : ((double)consumeChance >= 0.05 ? 67 : 91));
            widgets.add(Widgets.createTexturedWidget((ResourceLocation)BACKGROUND_TEXTURE, (int)(offsetX + 5), (int)(startPoint.y + 1 + 79), (float)offsetU, (float)6.0f, (int)6, (int)6, (int)128, (int)128));
            ++i;
        }
        if (display.growsWithoutCatalyst) {
            widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x, startPoint.y + 1 + 90), (Component)Component.translatable((String)"container.pastel.rei.crystallarieum.crafting_time_per_stage_seconds_catalyst_optional", (Object[])new Object[]{display.secondsPerStage})).leftAligned().color(0x3F3F3F).noShadow());
        } else {
            widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x, startPoint.y + 1 + 90), (Component)Component.translatable((String)"container.pastel.rei.crystallarieum.crafting_time_per_stage_seconds", (Object[])new Object[]{display.secondsPerStage})).leftAligned().color(0x3F3F3F).noShadow());
        }
    }

    public int getDisplayHeight() {
        return 108;
    }
}

