/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import earth.terrarium.pastel.attachments.data.PrimordialFireData;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PrimordialFireCommand {
    public static void register(LiteralCommandNode<CommandSourceStack> root) {
        LiteralCommandNode primordialFire = ((LiteralArgumentBuilder)Commands.literal((String)"primordial_fire").requires(source -> source.hasPermission(2))).build();
        ArgumentCommandNode targets = ((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(context -> PrimordialFireCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), 200))).build();
        ArgumentCommandNode targetsDuration = ((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> PrimordialFireCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration")))).build();
        targets.addChild((CommandNode)targetsDuration);
        primordialFire.addChild((CommandNode)targets);
        root.addChild((CommandNode)primordialFire);
    }

    private static int execute(CommandSourceStack source, Collection<? extends Entity> targets, int ticks) {
        int affectedTargets = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            PrimordialFireData.setPrimordialFireTicks(livingEntity, ticks);
            ++affectedTargets;
        }
        if (ticks > 0) {
            source.sendSuccess(() -> Component.translatable((String)"commands.pastel.primordial_fire.put_on.success", (Object[])new Object[]{targets.size()}), false);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.pastel.primordial_fire.put_out.success", (Object[])new Object[]{targets.size()}), false);
        }
        return affectedTargets;
    }
}

