/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;

public class DumpTagsCommand {
    public static void register(LiteralCommandNode<CommandSourceStack> root) {
        LiteralCommandNode dumpRegistries = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dump_tags").requires(source -> source.hasPermission(2))).executes(context -> DumpTagsCommand.execute((CommandSourceStack)context.getSource()))).build();
        root.addChild((CommandNode)dumpRegistries);
    }

    private static int execute(CommandSourceStack source) {
        File baseDir = FMLPaths.GAMEDIR.get().resolve("tag_dump").toFile();
        baseDir.mkdirs();
        source.registryAccess().registries().forEach(registry -> registry.value().getTags().forEach(pair -> {
            ResourceLocation registryId = ((HolderSet.Named)pair.getSecond()).key().registry().location();
            ResourceLocation tagId = ((HolderSet.Named)pair.getSecond()).key().location();
            File tagFile = new File(baseDir, tagId.getNamespace() + "/" + registryId.getPath() + "/" + tagId.getPath() + ".txt");
            try {
                tagFile.getParentFile().mkdirs();
                tagFile.createNewFile();
                FileWriter writer = new FileWriter(tagFile);
                for (Holder entry : (HolderSet.Named)pair.getSecond()) {
                    writer.write(((ResourceKey)entry.unwrapKey().get()).location().toString());
                    writer.write(System.lineSeparator());
                }
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        source.sendSystemMessage((Component)Component.literal((String)"Tags exported to directory 'tag_dump'"));
        return 0;
    }
}

