/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.blocks.item_roundel.ItemRoundelBlockEntity;
import earth.terrarium.pastel.blocks.structure.PreservationControllerBlock;
import earth.terrarium.pastel.blocks.structure.PreservationControllerBlockEntity;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PreservationRoundelBlockEntity
extends ItemRoundelBlockEntity
implements PlayerOwned {
    protected static final int INVENTORY_SIZE = 6;
    private UUID lastInteractedPlayer;
    protected Vec3i controllerOffset = new Vec3i(2, 2, 2);
    protected List<Item> requiredItems = new ArrayList<Item>();
    protected List<Vec3i> otherRoundelOffsets = new ArrayList<Vec3i>();

    public PreservationRoundelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ItemRoundelBlockEntity>)((BlockEntityType)PastelBlockEntities.PRESERVATION_ROUNDEL.get()), pos, state, 6);
        this.inventory.addListener(i -> this.inventoryChanged());
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.requiredItems = new ArrayList<Item>();
        if (nbt.contains("RequiredItems", 9)) {
            for (Tag e : nbt.getList("RequiredItems", 8)) {
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)e.getAsString()));
                if (item == Items.AIR) continue;
                this.requiredItems.add(item);
            }
        }
        this.controllerOffset = null;
        if (nbt.contains("ControllerOffset", 11)) {
            int[] offset = nbt.getIntArray("ControllerOffset");
            this.controllerOffset = new Vec3i(offset[0], offset[1], offset[2]);
        }
        this.otherRoundelOffsets = new ArrayList<Vec3i>();
        if (nbt.contains("OtherRoundelOffsets", 9)) {
            for (Tag e : nbt.getList("OtherRoundelOffsets", 11)) {
                int[] intArray = ((IntArrayTag)e).getAsIntArray();
                this.otherRoundelOffsets.add(new Vec3i(intArray[0], intArray[1], intArray[2]));
            }
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (!this.requiredItems.isEmpty()) {
            ListTag itemList = new ListTag();
            for (Item requiredItem : this.requiredItems) {
                itemList.add((Object)StringTag.valueOf((String)BuiltInRegistries.ITEM.getKey((Object)requiredItem).toString()));
            }
            nbt.put("RequiredItems", (Tag)itemList);
        }
        if (this.controllerOffset != null) {
            nbt.putIntArray("ControllerOffset", new int[]{this.controllerOffset.getX(), this.controllerOffset.getY(), this.controllerOffset.getZ()});
        }
        if (!this.otherRoundelOffsets.isEmpty()) {
            ListTag offsetList = new ListTag();
            for (Vec3i offset : this.otherRoundelOffsets) {
                offsetList.add((Object)new IntArrayTag(new int[]{offset.getX(), offset.getY(), offset.getZ()}));
            }
            nbt.put("OtherRoundelOffsets", (Tag)offsetList);
        }
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public void inventoryChanged() {
        BlockEntity blockEntity;
        if (this.level instanceof ServerLevel && this.controllerOffset != null && this.inventoryAndConnectedOnesMatchRequirement() && (blockEntity = this.level.getBlockEntity(Support.directionalOffset(this.worldPosition, this.controllerOffset, (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)PreservationControllerBlock.FACING)))) instanceof PreservationControllerBlockEntity) {
            PreservationControllerBlockEntity controller = (PreservationControllerBlockEntity)blockEntity;
            controller.openExit();
        }
    }

    public boolean inventoryAndConnectedOnesMatchRequirement() {
        if (!this.inventoryMatchesRequirement() || this.level == null) {
            return false;
        }
        for (Vec3i otherRoundelOffset : this.otherRoundelOffsets) {
            PreservationRoundelBlockEntity preservationRoundelBlockEntity;
            BlockPos otherRoundelPos = Support.directionalOffset(this.worldPosition, otherRoundelOffset, (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)PreservationControllerBlock.FACING));
            BlockEntity blockEntity = this.level.getBlockEntity(otherRoundelPos);
            if (!(blockEntity instanceof PreservationRoundelBlockEntity) || (preservationRoundelBlockEntity = (PreservationRoundelBlockEntity)blockEntity).inventoryMatchesRequirement()) continue;
            return false;
        }
        return true;
    }

    public boolean inventoryMatchesRequirement() {
        if (this.requiredItems.isEmpty()) {
            return false;
        }
        ArrayList<Item> requirements = new ArrayList<Item>(this.requiredItems);
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack slotStack = this.getItem(i);
            if (slotStack.isEmpty()) continue;
            int usedCount = 0;
            for (int j = 0; j < requirements.size(); ++j) {
                if (!slotStack.is((Item)requirements.get(j))) continue;
                requirements.remove(j);
                --j;
                if (slotStack.getCount() == ++usedCount) break;
            }
            if (usedCount == slotStack.getCount()) continue;
            return false;
        }
        if (requirements.isEmpty() && this.level != null) {
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)this.level, Vec3.atCenterOf((Vec3i)this.worldPosition), (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, 10, new Vec3(0.25, 0.5, 0.25), new Vec3(0.1, 0.1, 0.1));
            this.level.playSound(null, this.worldPosition, PastelSounds.NEW_RECIPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean renderStacksAsIndividualItems() {
        return true;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.lastInteractedPlayer;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.lastInteractedPlayer = playerEntity.getUUID();
        this.setChanged();
    }
}

