/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.blocks.structure.PreservationControllerBlock;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PreservationControllerBlockEntity
extends BlockEntity {
    private Vec3i entranceOffset;
    private Vec3i checkRange;
    private ResourceLocation requiredAdvancement;
    private MobEffect requiredEffect;
    private String checkName;
    private AABB checkBox;
    private Vec3i checkBoxOffset;
    private BlockPos destinationPos;
    private boolean spawnParticles;

    public PreservationControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.PRESERVATION_CONTROLLER.get(), pos, state);
    }

    public static void serverTick(@NotNull Level world, BlockPos blockPos, BlockState blockState, PreservationControllerBlockEntity blockEntity) {
        if (world.getGameTime() % 20L == 0L && blockEntity.entranceOffset != null && blockEntity.checkRange != null && blockEntity.requiredAdvancement != null) {
            if (blockEntity.checkBox == null) {
                PreservationControllerBlockEntity.calculateLocationData(world, blockPos, blockState, blockEntity);
            }
            if (blockEntity.spawnParticles) {
                blockEntity.spawnParticles();
            }
            if (blockEntity.requiredAdvancement != null) {
                blockEntity.yeetUnworthyPlayersAndGrantAdvancement();
            }
        }
    }

    private static void calculateLocationData(Level world, BlockPos blockPos, @NotNull BlockState blockState, @NotNull PreservationControllerBlockEntity blockEntity) {
        BlockState state = world.getBlockState(blockPos);
        if (!state.is((Block)PastelBlocks.PRESERVATION_CONTROLLER.get())) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)PreservationControllerBlock.FACING);
        BlockPos centerPos = blockPos;
        if (blockEntity.checkBoxOffset != null) {
            centerPos = Support.directionalOffset(blockEntity.worldPosition, blockEntity.checkBoxOffset, (Direction)blockState.getValue((Property)PreservationControllerBlock.FACING));
        }
        blockEntity.checkBox = facing == Direction.NORTH || facing == Direction.SOUTH ? AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)centerPos), (double)(blockEntity.checkRange.getX() * 2), (double)(blockEntity.checkRange.getY() * 2), (double)(blockEntity.checkRange.getZ() * 2)) : AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)centerPos), (double)(blockEntity.checkRange.getZ() * 2), (double)(blockEntity.checkRange.getY() * 2), (double)(blockEntity.checkRange.getX() * 2));
        blockEntity.destinationPos = Support.directionalOffset(blockEntity.worldPosition, blockEntity.entranceOffset, (Direction)blockState.getValue((Property)PreservationControllerBlock.FACING));
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ResourceLocation effectIdentifier;
        super.saveAdditional(nbt, registryLookup);
        if (this.entranceOffset != null) {
            nbt.putInt("EntranceOffsetX", this.entranceOffset.getX());
            nbt.putInt("EntranceOffsetY", this.entranceOffset.getY());
            nbt.putInt("EntranceOffsetZ", this.entranceOffset.getZ());
        }
        if (this.checkBoxOffset != null) {
            nbt.putInt("CheckBoxOffsetX", this.checkBoxOffset.getX());
            nbt.putInt("CheckBoxOffsetY", this.checkBoxOffset.getY());
            nbt.putInt("CheckBoxOffsetZ", this.checkBoxOffset.getZ());
        }
        if (this.checkRange != null) {
            nbt.putInt("CheckRangeX", this.checkRange.getX());
            nbt.putInt("CheckRangeY", this.checkRange.getY());
            nbt.putInt("CheckRangeZ", this.checkRange.getZ());
        }
        if (this.requiredAdvancement != null) {
            nbt.putString("RequiredAdvancement", this.requiredAdvancement.toString());
        }
        if (this.requiredEffect != null && (effectIdentifier = BuiltInRegistries.MOB_EFFECT.getKey((Object)this.requiredEffect)) != null) {
            nbt.putString("RequiredStatusEffect", effectIdentifier.toString());
        }
        if (this.checkName != null) {
            nbt.putString("CheckName", this.checkName);
        }
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        if (nbt.contains("EntranceOffsetX") && nbt.contains("EntranceOffsetY") && nbt.contains("EntranceOffsetZ")) {
            this.entranceOffset = new Vec3i(nbt.getInt("EntranceOffsetX"), nbt.getInt("EntranceOffsetY"), nbt.getInt("EntranceOffsetZ"));
        }
        if (nbt.contains("CheckBoxOffsetX") && nbt.contains("CheckBoxOffsetY") && nbt.contains("CheckBoxOffsetZ")) {
            this.checkBoxOffset = new Vec3i(nbt.getInt("CheckBoxOffsetX"), nbt.getInt("CheckBoxOffsetY"), nbt.getInt("CheckBoxOffsetZ"));
        }
        if (nbt.contains("CheckRangeX")) {
            this.checkRange = new Vec3i(nbt.getInt("CheckRangeX"), nbt.getInt("CheckRangeY"), nbt.getInt("CheckRangeZ"));
        }
        if (nbt.contains("RequiredStatusEffect", 8)) {
            MobEffect statusEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)nbt.getString("RequiredStatusEffect")));
            if (this.requiredEffect != null) {
                this.requiredEffect = statusEffect;
            }
        }
        if (nbt.contains("RequiredAdvancement", 8)) {
            this.requiredAdvancement = ResourceLocation.parse((String)nbt.getString("RequiredAdvancement"));
        }
        if (nbt.contains("CheckName", 8)) {
            this.checkName = nbt.getString("CheckName");
        }
        if (nbt.contains("UnlockedAdvancement", 8)) {
            ResourceLocation unlockedAdvancement = ResourceLocation.parse((String)nbt.getString("UnlockedAdvancement"));
            this.checkName = unlockedAdvancement.getPath();
        }
    }

    public void spawnParticles() {
        if (this.spawnParticles) {
            if (this.checkBox != null) {
                BlockPos centerPos = this.worldPosition;
                if (this.checkBoxOffset != null) {
                    centerPos = Support.directionalOffset(this.worldPosition, this.checkBoxOffset, (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)PreservationControllerBlock.FACING));
                }
                PlayParticleWithExactVelocityPayload.playParticles((ServerLevel)this.level, centerPos, (ParticleOptions)ParticleTypes.FLAME, 1);
                PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)this.level, Vec3.atCenterOf((Vec3i)centerPos), (ParticleOptions)ParticleTypes.SMOKE, 250, new Vec3(this.checkBox.getXsize() / 2.0, this.checkBox.getYsize() / 2.0, this.checkBox.getZsize() / 2.0), Vec3.ZERO);
            }
            if (this.destinationPos != null) {
                PlayParticleWithExactVelocityPayload.playParticles((ServerLevel)this.level, this.destinationPos, (ParticleOptions)ParticleTypes.END_ROD, 1);
            }
        }
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public void toggleParticles() {
        this.spawnParticles = true;
    }

    public void openExit() {
        boolean didSomething = false;
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (!state.is((Block)PastelBlocks.PRESERVATION_CONTROLLER.get())) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)PreservationControllerBlock.FACING);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            for (int x = -1; x < 2; ++x) {
                for (int y = -3; y < 0; ++y) {
                    BlockPos offsetPos = this.worldPosition.offset(x, y, 0);
                    BlockState offsetState = this.level.getBlockState(offsetPos);
                    if (!offsetState.is(PastelBlockTags.UNBREAKABLE_STRUCTURE_BLOCKS)) continue;
                    this.level.setBlockAndUpdate(offsetPos, ((Block)PastelBlocks.POLISHED_CALCITE.get()).defaultBlockState());
                    this.level.globalLevelEvent(2001, offsetPos, Block.getId((BlockState)offsetState));
                    didSomething = true;
                }
            }
        } else {
            for (int z = -1; z < 2; ++z) {
                for (int y = -3; y < 0; ++y) {
                    BlockPos offsetPos = this.worldPosition.offset(0, y, z);
                    BlockState offsetState = this.level.getBlockState(offsetPos);
                    if (!offsetState.is(PastelBlockTags.UNBREAKABLE_STRUCTURE_BLOCKS)) continue;
                    this.level.setBlockAndUpdate(offsetPos, ((Block)PastelBlocks.POLISHED_CALCITE.get()).defaultBlockState());
                    this.level.globalLevelEvent(2001, offsetPos, Block.getId((BlockState)offsetState));
                    didSomething = true;
                }
            }
        }
        if (didSomething) {
            this.level.playSound(null, this.worldPosition, PastelSounds.STRUCTURE_SUCCESS, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void yeetPlayer(@NotNull Player player) {
        if (this.destinationPos != null) {
            player.hurt(PastelDamageTypes.dike(player.level()), 1.0f);
            Vec3 vec = Vec3.atCenterOf((Vec3i)this.destinationPos);
            player.teleportTo(vec.x(), vec.y(), vec.z());
            this.level.playSound(null, this.destinationPos, PastelSounds.USE_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void yeetUnworthyPlayersAndGrantAdvancement() {
        if (this.checkBox != null) {
            List players = this.level.getEntities((EntityTypeTest)EntityType.PLAYER, this.checkBox, LivingEntity::isAlive);
            for (Player playerEntity : players) {
                if (playerEntity.isCreative() || playerEntity.isSpectator()) continue;
                boolean worthy = this.requiredAdvancement == null || DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)this.requiredAdvancement);
                PastelCriteria.PRESERVATION_CHECK.trigger((ServerPlayer)playerEntity, this.checkName, worthy);
                if (worthy) continue;
                this.yeetPlayer(playerEntity);
            }
        }
    }
}

