/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PlayerTrackerBlockEntity
extends BlockEntity {
    private final List<UUID> playersThatOpenedAlready = new ArrayList<UUID>();

    public PlayerTrackerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.PLAYER_TRACKING.get(), pos, state);
    }

    public boolean hasTaken(Player player) {
        return this.playersThatOpenedAlready.contains(player.getUUID());
    }

    public void markTaken(Player player) {
        this.playersThatOpenedAlready.add(player.getUUID());
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        if (!this.playersThatOpenedAlready.isEmpty()) {
            ListTag uuidList = new ListTag();
            for (UUID uuid : this.playersThatOpenedAlready) {
                CompoundTag nbtCompound = new CompoundTag();
                nbtCompound.putUUID("UUID", uuid);
                uuidList.add((Object)nbtCompound);
            }
            tag.put("OpenedPlayers", (Tag)uuidList);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        this.playersThatOpenedAlready.clear();
        if (tag.contains("OpenedPlayers", 9)) {
            ListTag list = tag.getList("OpenedPlayers", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.getCompound(i);
                UUID uuid = compound.getUUID("UUID");
                this.playersThatOpenedAlready.add(uuid);
            }
        }
    }
}

