/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.structure;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeProvider;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Iterator;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DikeGateBlock
extends TransparentBlock {
    public static final MapCodec<DikeGateBlock> CODEC = DikeGateBlock.simpleCodec(DikeGateBlock::new);

    public DikeGateBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends DikeGateBlock> codec() {
        return CODEC;
    }

    @Deprecated
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityShapeContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityShapeContext = (EntityCollisionContext)context).getEntity()) instanceof LivingEntity) {
            Player player;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof Player && (player = (Player)entity).isCreative()) {
                return Shapes.empty();
            }
            float charges = AzureDikeProvider.getAzureDikeCharges(livingEntity);
            if (charges > 0.0f) {
                return Shapes.empty();
            }
        }
        return Shapes.block();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (context.isHoldingItem(this.asItem())) {
            return Shapes.block();
        }
        return this.getCollisionShape(state, world, pos, context);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        this.punishEntityWithoutAzureDike((BlockGetter)world, pos, (Entity)player, false);
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        this.punishEntityWithoutAzureDike(world, pos, (Entity)player, true);
        return super.getDestroyProgress(state, player, world, pos);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        this.punishEntityWithoutAzureDike((BlockGetter)world, pos, entity, true);
        super.entityInside(state, world, pos, entity);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Iterator directions = Util.shuffledCopy((Object[])Direction.values(), (RandomSource)random).iterator();
        for (int i = 0; i < 2; ++i) {
            Direction direction = (Direction)directions.next();
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState = world.getBlockState(blockPos);
            if (state.canOcclude() && blockState.isFaceSturdy((BlockGetter)world, blockPos, direction.getOpposite())) continue;
            double d = direction.getStepX() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepX() * 0.6;
            double e = direction.getStepY() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepY() * 0.6;
            double f = direction.getStepZ() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepZ() * 0.6;
            world.addParticle((ParticleOptions)PastelParticleTypes.AZURE_DIKE_RUNES, (double)pos.getX() + d, (double)pos.getY() + e, (double)pos.getZ() + f, 0.0, 0.025, 0.0);
        }
    }

    public void punishEntityWithoutAzureDike(BlockGetter world, BlockPos pos, Entity entity, boolean decreasedSounds) {
        if (world instanceof ServerLevel) {
            LivingEntity livingEntity;
            int charges;
            ServerLevel serverWorld = (ServerLevel)world;
            if (entity instanceof LivingEntity && (charges = (int)Math.ceil(AzureDikeProvider.getAzureDikeCharges(livingEntity = (LivingEntity)entity))) == 0) {
                entity.hurt(PastelDamageTypes.dike((Level)serverWorld), 1.0f);
                PlayParticleWithExactVelocityPayload.playParticles(serverWorld, pos, (ParticleOptions)PastelParticleTypes.AZURE_DIKE_RUNES, 10);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
                    if (!decreasedSounds || ((ServerLevel)world).getGameTime() % 10L == 0L) {
                        serverPlayerEntity.playNotifySound(PastelSounds.USE_FAIL, SoundSource.PLAYERS, 0.75f, 1.0f);
                    }
                }
            }
        }
    }
}

