/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.redstone.DetectorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WeatherDetectorBlock
extends DetectorBlock {
    public static final MapCodec<WeatherDetectorBlock> CODEC = WeatherDetectorBlock.simpleCodec(WeatherDetectorBlock::new);

    public WeatherDetectorBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends WeatherDetectorBlock> codec() {
        return CODEC;
    }

    @Override
    protected void updateState(BlockState state, Level world, BlockPos pos) {
        int power = 0;
        if (world.isThundering()) {
            Biome.Precipitation precipitation = ((Biome)world.getBiome(pos).value()).getPrecipitationAt(pos);
            switch (precipitation) {
                case RAIN: {
                    power = 15;
                    break;
                }
                case SNOW: {
                    power = 8;
                    break;
                }
                case NONE: {
                    power = 0;
                }
            }
        } else if (world.isRaining()) {
            Biome.Precipitation precipitation = ((Biome)world.getBiome(pos).value()).getPrecipitationAt(pos);
            switch (precipitation) {
                case RAIN: 
                case SNOW: {
                    power = 8;
                    break;
                }
                case NONE: {
                    power = 0;
                }
            }
        }
        int n = power = (Boolean)state.getValue((Property)INVERTED) != false ? 15 - power : power;
        if ((Integer)state.getValue((Property)POWER) != power) {
            world.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(power)), 3);
        }
    }

    @Override
    int getUpdateFrequencyTicks() {
        return 20;
    }
}

