/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.api.block.ColorableBlock;
import earth.terrarium.pastel.blocks.redstone.RedstoneTransceiverBlockEntity;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneTransceiverBlock
extends DiodeBlock
implements EntityBlock,
ColorableBlock {
    public static final MapCodec<RedstoneTransceiverBlock> CODEC = RedstoneTransceiverBlock.simpleCodec(RedstoneTransceiverBlock::new);
    public static final BooleanProperty SENDER = BooleanProperty.create((String)"sender");
    public static final EnumProperty<DyeColor> CHANNEL = EnumProperty.create((String)"channel", DyeColor.class);

    public RedstoneTransceiverBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SENDER, (Comparable)Boolean.valueOf(true))).setValue(CHANNEL, (Comparable)DyeColor.RED));
    }

    public MapCodec<? extends RedstoneTransceiverBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RedstoneTransceiverBlockEntity(pos, state);
    }

    protected int getDelay(BlockState state) {
        return 0;
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, @NotNull Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!this.tryColorUsingStackInHand(handStack, world, pos, player, hand)) {
            this.toggleSendingMode(world, pos, state);
        }
        return ItemInteractionResult.CONSUME;
    }

    public void toggleSendingMode(@NotNull Level world, BlockPos blockPos, @NotNull BlockState state) {
        BlockState newState = (BlockState)state.setValue((Property)SENDER, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)SENDER) == false));
        world.setBlock(blockPos, newState, 2);
        if (((Boolean)newState.getValue((Property)SENDER)).booleanValue()) {
            world.playSound(null, blockPos, PastelSounds.REDSTONE_MECHANISM_TRIGGER, SoundSource.BLOCKS, 0.3f, 0.9f);
        } else {
            world.playSound(null, blockPos, PastelSounds.REDSTONE_MECHANISM_TRIGGER, SoundSource.BLOCKS, 0.3f, 1.1f);
        }
        this.checkTickOnNeighbor(world, blockPos, newState);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, SENDER, CHANNEL});
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener getListener(ServerLevel world, T blockEntity) {
        return blockEntity instanceof RedstoneTransceiverBlockEntity ? ((RedstoneTransceiverBlockEntity)blockEntity).getEventListener() : null;
    }

    public void checkTickOnNeighbor(Level world, BlockPos pos, BlockState state) {
        int newSignal = world.getBestNeighborSignal(pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneTransceiverBlockEntity) {
            RedstoneTransceiverBlockEntity RedstoneTransceiverBlockEntity2 = (RedstoneTransceiverBlockEntity)blockEntity;
            if (((Boolean)state.getValue((Property)SENDER)).booleanValue()) {
                int lastSignal = RedstoneTransceiverBlockEntity2.getCurrentSignalStrength();
                if (newSignal != lastSignal) {
                    RedstoneTransceiverBlockEntity2.setSignalStrength(newSignal);
                }
                if (newSignal == 0) {
                    world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
                } else {
                    world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
        }
    }

    protected int getOutputSignal(@NotNull BlockGetter world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity instanceof RedstoneTransceiverBlockEntity ? ((RedstoneTransceiverBlockEntity)blockEntity).getCurrentSignal() : 0;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide) {
            this.checkTickOnNeighbor(world, pos, state);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : Support.checkType(type, (BlockEntityType)PastelBlockEntities.REDSTONE_TRANSCEIVER.get(), RedstoneTransceiverBlockEntity::serverTick);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            double y = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            double z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
            world.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean color(Level world, BlockPos pos, Optional<DyeColor> color, @Nullable Entity user) {
        if (color.isEmpty()) {
            return false;
        }
        if (this.getColor(world, pos) == color) {
            return false;
        }
        world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue(CHANNEL, (Comparable)color.get()));
        return true;
    }

    @Override
    public Optional<DyeColor> getColor(Level world, BlockPos pos) {
        return Optional.of((DyeColor)world.getBlockState(pos).getValue(CHANNEL));
    }
}

