/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PlayerDetectorBlockEntity
extends BlockEntity
implements PlayerOwned {
    private UUID ownerUUID;
    private String ownerName;

    public PlayerDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.PLAYER_DETECTOR.get(), blockPos, blockState);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        if (this.ownerUUID != null) {
            tag.putUUID("UUID", this.ownerUUID);
        }
        if (this.ownerName != null) {
            tag.putString("OwnerName", this.ownerName);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        this.ownerUUID = tag.contains("UUID") ? tag.getUUID("UUID") : null;
        this.ownerName = tag.contains("OwnerName") ? tag.getString("OwnerName") : "";
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.ownerName = playerEntity.getName().getString();
        this.setChanged();
    }
}

