/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.redstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.redstone.DetectorBlock;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;

public class ItemDetectorBlock
extends DetectorBlock {
    public static final MapCodec<ItemDetectorBlock> CODEC = ItemDetectorBlock.simpleCodec(ItemDetectorBlock::new);

    public ItemDetectorBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends ItemDetectorBlock> codec() {
        return CODEC;
    }

    @Override
    protected void updateState(BlockState state, Level world, BlockPos pos) {
        int power;
        List items = world.getEntities((EntityTypeTest)EntityType.ITEM, this.getDetectionBox(pos), Entity::isAlive);
        if (items.size() > 0) {
            ItemEntity itementity;
            ItemStack itemStack;
            int amount = 0;
            Iterator iterator = items.iterator();
            while (iterator.hasNext() && (amount += (itemStack = (itementity = (ItemEntity)iterator.next()).getItem()).getCount()) < 64) {
            }
            power = Math.max(1, Math.min(amount / 4, 15));
        } else {
            power = 0;
        }
        int n = power = (Boolean)state.getValue((Property)INVERTED) != false ? 15 - power : power;
        if ((Integer)state.getValue((Property)POWER) != power) {
            world.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(power)), 3);
        }
    }

    @Override
    int getUpdateFrequencyTicks() {
        return 20;
    }
}

