/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.present;

import com.mojang.authlib.GameProfile;
import earth.terrarium.pastel.blocks.present.PresentBlock;
import earth.terrarium.pastel.components.ExtendedBundleComponent;
import earth.terrarium.pastel.components.WrappedPresentComponent;
import earth.terrarium.pastel.items.bundles.PlaceableBundleBlockItem;
import earth.terrarium.pastel.items.tooltip.PresentTooltipData;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class PresentBlockItem
extends PlaceableBundleBlockItem {
    public static final int MAX_STORAGE_STACKS = 5;

    public PresentBlockItem(Block block, Item.Properties settings) {
        super(new ExtendedBundleComponent(5), block, settings);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        return PresentBlockItem.isWrapped(context.getItemInHand()) && super.canPlace(context, state);
    }

    public static void setOwner(ItemStack itemStack, Player giver) {
        GameProfile profile = new GameProfile(giver.getUUID(), giver.getName().getString());
        itemStack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(profile));
    }

    public static Optional<ResolvableProfile> getOwner(ItemStack itemStack) {
        return Optional.ofNullable((ResolvableProfile)itemStack.get(DataComponents.PROFILE));
    }

    public static boolean isEmpty(ItemStack itemStack) {
        return ((BundleContents)itemStack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY)).isEmpty();
    }

    public static boolean isWrapped(ItemStack itemStack) {
        return PresentBlockItem.getWrapData(itemStack).wrapped();
    }

    public static WrappedPresentComponent getWrapData(ItemStack itemStack) {
        return (WrappedPresentComponent)itemStack.getOrDefault(PastelDataComponentTypes.WRAPPED_PRESENT, (Object)WrappedPresentComponent.DEFAULT);
    }

    public static void wrap(ItemStack itemStack, PresentBlock.WrappingPaper wrappingPaper, Map<Integer, Integer> colors) {
        itemStack.set(PastelDataComponentTypes.WRAPPED_PRESENT, (Object)new WrappedPresentComponent(true, wrappingPaper, colors));
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        return !this.isCraftingInventory(slot) && super.overrideOtherStackedOnMe(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (PresentBlockItem.isWrapped(itemStack)) {
            super.use(world, user, hand);
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    private boolean isCraftingInventory(Slot slot) {
        return slot.container instanceof TransientCraftingContainer;
    }

    public void onCraftedBy(ItemStack stack, Level world, Player player) {
        super.onCraftedBy(stack, world, player);
        if (player != null) {
            PresentBlockItem.setOwner(stack, player);
        }
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return !PresentBlockItem.isWrapped(stack) && super.isBarVisible(stack);
    }

    public static Stream<ItemStack> getBundledStacks(ItemStack stack) {
        return ((BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY)).itemCopyStream();
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (PresentBlockItem.isWrapped(stack)) {
            return Optional.empty();
        }
        NonNullList list = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
        List<ItemStack> stacks = PresentBlockItem.getBundledStacks(stack).toList();
        for (int i = 0; i < stacks.size() && i < list.size(); ++i) {
            list.set(i, (Object)stacks.get(i));
        }
        return Optional.of(new PresentTooltipData((List<ItemStack>)list));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        boolean wrapped = PresentBlockItem.isWrapped(stack);
        if (wrapped) {
            Optional<ResolvableProfile> gifter = PresentBlockItem.getOwner(stack);
            if (gifter.isPresent()) {
                gifter.get().name().ifPresent(name -> tooltip.add((Component)Component.translatable((String)"block.pastel.present.tooltip.wrapped.giver", (Object[])new Object[]{name}).withStyle(ChatFormatting.GRAY)));
                if (type.isAdvanced()) {
                    gifter.get().id().ifPresent(id -> tooltip.add((Component)Component.literal((String)("UUID: " + String.valueOf(id))).withStyle(ChatFormatting.GRAY)));
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"block.pastel.present.tooltip.wrapped").withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"block.pastel.present.tooltip.description").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"block.pastel.present.tooltip.description2").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{PresentBlockItem.getBundledStacks(stack).count(), 5}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }
}

