/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pedestal;

import earth.terrarium.pastel.registries.PastelItems;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class PedestalRecipeInput
implements RecipeInput {
    private static final List<ItemStack> FULL_GEMSTONE_POWDER_STACKS = List.of(new ItemStack((ItemLike)PastelItems.TOPAZ_POWDER.get(), 64), new ItemStack((ItemLike)PastelItems.AMETHYST_POWDER.get(), 64), new ItemStack((ItemLike)PastelItems.CITRINE_POWDER.get(), 64), new ItemStack((ItemLike)PastelItems.ONYX_POWDER.get(), 64), new ItemStack((ItemLike)PastelItems.MOONSTONE_POWDER.get(), 64));
    @Nullable
    private final Player player;
    private final CraftingInput craftingGridInput;
    private final List<ItemStack> gemstonePowderStacks;

    public PedestalRecipeInput(CraftingInput craftingGridInput, List<ItemStack> gemstonePowderStacks, @Nullable Player player) {
        this.player = player;
        this.craftingGridInput = craftingGridInput;
        this.gemstonePowderStacks = gemstonePowderStacks;
    }

    public CraftingInput getCraftingGridInput() {
        return this.craftingGridInput;
    }

    public static PedestalRecipeInput create(List<ItemStack> stacks, @Nullable Player player) {
        return new PedestalRecipeInput(CraftingInput.of((int)3, (int)3, stacks.subList(0, 9)), stacks.subList(9, 14), player);
    }

    public static PedestalRecipeInput createWithFullGemstonePowder(List<ItemStack> stacks, @Nullable Player player) {
        return new PedestalRecipeInput(CraftingInput.of((int)3, (int)3, stacks), FULL_GEMSTONE_POWDER_STACKS, player);
    }

    public ItemStack getItem(int slot) {
        if (slot < 9) {
            return slot < this.craftingGridInput.size() ? this.craftingGridInput.getItem(slot) : ItemStack.EMPTY;
        }
        return (slot -= 9) < this.gemstonePowderStacks.size() ? this.gemstonePowderStacks.get(slot) : ItemStack.EMPTY;
    }

    public int size() {
        return this.craftingGridInput.size() + this.gemstonePowderStacks.size();
    }

    public int[] getCraftingGridSlots() {
        int size = this.craftingGridInput.size();
        int[] slots = new int[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }
}

