/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pastel_network.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.pastel_network.Pastel;
import earth.terrarium.pastel.blocks.pastel_network.network.NodeRemovalReason;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelTransmission;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelTransmissionLogic;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeType;
import earth.terrarium.pastel.helpers.data.SchedulerMap;
import earth.terrarium.pastel.helpers.interaction.TickLooper;
import earth.terrarium.pastel.networking.s2c_payloads.PastelNetworkEdgeSyncPayload;
import earth.terrarium.pastel.networking.s2c_payloads.PastelNetworkRemovedPayload;
import earth.terrarium.pastel.networking.s2c_payloads.PastelNodeStatusUpdatePayload;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;

public class ServerPastelNetwork
extends PastelNetwork<ServerLevel> {
    public static final Codec<ServerPastelNetwork> CODEC = RecordCodecBuilder.create(i -> i.group((App)Level.RESOURCE_KEY_CODEC.xmap(k -> PastelCommon.getSidedServer().getLevel(k), Level::dimension).fieldOf("world").forGetter(b -> (ServerLevel)b.world), (App)UUIDUtil.STRING_CODEC.fieldOf("uuid").forGetter(PastelNetwork::getUUID), (App)Codec.INT.fieldOf("color").forGetter(PastelNetwork::getColor), (App)TickLooper.CODEC.fieldOf("looper").forGetter(b -> b.transferLooper)).apply((Applicative)i, ServerPastelNetwork::new));
    protected final Map<PastelNodeType, Set<PastelNodeBlockEntity>> loadedNodes = new ConcurrentHashMap<PastelNodeType, Set<PastelNodeBlockEntity>>();
    protected final Set<PastelNodeBlockEntity> priorityNodes = new HashSet<PastelNodeBlockEntity>();
    protected final Set<PastelNodeBlockEntity> highPriorityNodes = new HashSet<PastelNodeBlockEntity>();
    private final TickLooper transferLooper;
    protected final SchedulerMap<PastelTransmission> transmissions;
    protected final PastelTransmissionLogic transmissionLogic;

    public ServerPastelNetwork(ServerLevel world, UUID uuid, int color) {
        this(world, uuid, color, new TickLooper(10));
    }

    public ServerPastelNetwork(ServerLevel world, PastelNodeBlockEntity initialNode) {
        this(world, initialNode.getNodeId(), initialNode.getPastelNetworkColor(), new TickLooper(10));
        this.addNode(initialNode);
    }

    public ServerPastelNetwork(ServerLevel world, UUID uuid, int color, TickLooper transferLoop) {
        super(world, uuid, color);
        this.transferLooper = transferLoop;
        this.transmissions = new SchedulerMap();
        this.transmissionLogic = new PastelTransmissionLogic(this);
        for (PastelNodeType type : PastelNodeType.values()) {
            this.loadedNodes.put(type, new HashSet());
        }
        for (Map.Entry entry : this.transmissions) {
            ((PastelTransmission)entry.getKey()).setNetwork(this);
        }
    }

    private boolean addLoadedNode(PastelNodeBlockEntity node) {
        return !this.loadedNodes.get((Object)node.getNodeType()).add(node);
    }

    public void initializeNode(PastelNodeBlockEntity node) {
        Set<PastelNodeBlockEntity> type = this.loadedNodes.get((Object)node.getNodeType());
        if (!type.contains(node)) {
            type.add(node);
            this.addPriorityNode(node);
        }
    }

    private void addPriorityNode(PastelNodeBlockEntity node) {
        switch (node.getPriority()) {
            case MODERATE: {
                this.priorityNodes.add(node);
                break;
            }
            case HIGH: {
                this.highPriorityNodes.add(node);
            }
        }
    }

    public void updateNodePriority(PastelNodeBlockEntity node, PastelNetwork.NodePriority oldPriority) {
        this.removePriorityNode(node, oldPriority);
        this.addPriorityNode(node);
    }

    @Override
    public String getNodeDebugText() {
        return super.getNodeDebugText() + " - Prov: " + this.getLoadedNodes(PastelNodeType.PROVIDER).size() + " - Send: " + this.getLoadedNodes(PastelNodeType.SENDER).size() + " - Gath: " + this.getLoadedNodes(PastelNodeType.GATHER).size() + " - Stor: " + this.getLoadedNodes(PastelNodeType.STORAGE).size() + " - Buff: " + this.getLoadedNodes(PastelNodeType.BUFFER).size() + " - Conn: " + this.getLoadedNodes(PastelNodeType.CONNECTION).size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.uuid.toString());
        for (PastelNodeType type : PastelNodeType.values()) {
            builder.append("-").append(this.getLoadedNodes(type).size());
        }
        return builder.toString();
    }

    @Nullable
    protected PastelNodeBlockEntity getLoadedNodeAt(BlockPos blockPos) {
        if (!this.graph.vertexSet().contains(blockPos)) {
            return null;
        }
        if (!((ServerLevel)this.getLevel()).hasChunkAt(blockPos)) {
            return null;
        }
        BlockEntity blockEntity = ((ServerLevel)this.getLevel()).getBlockEntity(blockPos);
        if (blockEntity instanceof PastelNodeBlockEntity) {
            PastelNodeBlockEntity pastelNodeBlockEntity = (PastelNodeBlockEntity)blockEntity;
            return pastelNodeBlockEntity;
        }
        return null;
    }

    private void removePriorityNode(PastelNodeBlockEntity node, PastelNetwork.NodePriority priority) {
        switch (priority) {
            case MODERATE: {
                this.priorityNodes.remove(node);
                break;
            }
            case HIGH: {
                this.highPriorityNodes.remove(node);
            }
        }
    }

    public Set<PastelNodeBlockEntity> getLoadedNodes(PastelNodeType type) {
        return this.getLoadedNodes(type, PastelNetwork.NodePriority.GENERIC);
    }

    public Set<PastelNodeBlockEntity> getLoadedNodes(PastelNodeType type, PastelNetwork.NodePriority priority) {
        Set<PastelNodeBlockEntity> nodeType = this.loadedNodes.get((Object)type);
        if (priority == PastelNetwork.NodePriority.MODERATE) {
            return nodeType.stream().filter(this.priorityNodes::contains).collect(Collectors.toSet());
        }
        if (priority == PastelNetwork.NodePriority.HIGH) {
            return nodeType.stream().filter(this.highPriorityNodes::contains).collect(Collectors.toSet());
        }
        return nodeType;
    }

    protected void addNode(PastelNodeBlockEntity node) {
        if (this.graph.containsVertex((Object)node.getBlockPos())) {
            this.loadedNodes.get((Object)node.getNodeType()).add(node);
        } else {
            if (this.addLoadedNode(node)) {
                return;
            }
            this.graph.addVertex((Object)node.getBlockPos());
        }
        this.addPriorityNode(node);
        node.setNetworkUUID(this.getUUID());
    }

    protected void addNodeAndConnect(PastelNodeBlockEntity newNode, PastelNodeBlockEntity existing) {
        this.addNode(newNode);
        this.getGraph().addEdge((Object)newNode.getBlockPos(), (Object)existing.getBlockPos());
        PastelNetworkEdgeSyncPayload.send(this, newNode.getBlockPos());
    }

    private void checkForNetworkSplit(BlockPos sourcePos) {
        ConnectivityInspector connectivityInspector;
        List connectedSets;
        Set vertices = this.graph.vertexSet();
        if (this.graph.vertexSet().size() < 2) {
            for (BlockPos vertex : vertices) {
                Optional be = ((ServerLevel)this.world).getBlockEntity(vertex, (BlockEntityType)PastelBlockEntities.PASTEL_NODE.get());
                be.ifPresent(pastelNodeBlockEntity -> pastelNodeBlockEntity.setNetworkUUID(null));
            }
            Pastel.getServerInstance().removeNetwork(this.getUUID());
        }
        if ((connectedSets = (connectivityInspector = new ConnectivityInspector(this.graph)).connectedSets()).size() == 1) {
            return;
        }
        int biggestSetSize = 0;
        Set biggestSet = null;
        ArrayList<Set> smallerSets = new ArrayList<Set>();
        for (Set set : connectedSets) {
            int size = set.size();
            if (size > biggestSetSize) {
                biggestSetSize = size;
                if (biggestSet != null) {
                    smallerSets.add(biggestSet);
                }
                biggestSet = set;
                continue;
            }
            smallerSets.add(set);
        }
        if (biggestSetSize == 1) {
            for (BlockPos pos : this.graph.vertexSet()) {
                Optional blockEntity = ((ServerLevel)this.world).getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.PASTEL_NODE.get());
                blockEntity.ifPresent(pastelNodeBlockEntity -> pastelNodeBlockEntity.setNetworkUUID(null));
            }
            PastelNetworkRemovedPayload.send(this);
            return;
        }
        ObjectOpenHashSet disconnectedBEs = new ObjectOpenHashSet();
        for (Set smallerSet : smallerSets) {
            boolean isSingleNode;
            boolean bl = isSingleNode = smallerSet.size() == 1;
            if (isSingleNode) {
                Optional blockEntity = ((ServerLevel)this.world).getBlockEntity((BlockPos)smallerSet.stream().findAny().get(), (BlockEntityType)PastelBlockEntities.PASTEL_NODE.get());
                if (!blockEntity.isPresent()) continue;
                ((PastelNodeBlockEntity)blockEntity.get()).setNetworkUUID(null);
                disconnectedBEs.add((PastelNodeBlockEntity)blockEntity.get());
                continue;
            }
            PastelNodeBlockEntity initialNode = null;
            ObjectArraySet blockEntities = new ObjectArraySet();
            for (BlockPos pos : smallerSet) {
                Optional blockEntity = ((ServerLevel)this.world).getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.PASTEL_NODE.get());
                if (!blockEntity.isPresent()) continue;
                disconnectedBEs.add((PastelNodeBlockEntity)blockEntity.get());
                blockEntities.add((PastelNodeBlockEntity)blockEntity.get());
                if (initialNode != null) continue;
                initialNode = (PastelNodeBlockEntity)blockEntity.get();
            }
            ServerPastelNetwork newNetwork = Pastel.getServerInstance().createNetwork((ServerLevel)this.world, initialNode);
            Object2ObjectArrayMap edges = new Object2ObjectArrayMap();
            for (BlockPos blockPos : smallerSet) {
                for (DefaultEdge edge : this.graph.edgesOf((Object)blockPos)) {
                    edges.put((BlockPos)this.graph.getEdgeSource((Object)edge), (BlockPos)this.graph.getEdgeTarget((Object)edge));
                }
                Optional couldBeANode = ((ServerLevel)this.getLevel()).getBlockEntity(blockPos, (BlockEntityType)PastelBlockEntities.PASTEL_NODE.get());
                if (!couldBeANode.isPresent()) continue;
                PastelNodeBlockEntity pastelNode = (PastelNodeBlockEntity)couldBeANode.get();
                newNetwork.addNode(pastelNode);
                pastelNode.setNetworkUUID(newNetwork.getUUID());
            }
            for (Map.Entry entry : edges.entrySet()) {
                newNetwork.addEdge((BlockPos)entry.getKey(), (BlockPos)entry.getValue());
            }
        }
        for (PastelNodeBlockEntity p : disconnectedBEs) {
            this.removeNode(p, NodeRemovalReason.REMOVED);
        }
        PastelNetworkEdgeSyncPayload.send(this, sourcePos);
        this.transmissionLogic.invalidateCache();
    }

    public void incorporate(ServerPastelNetwork networkToIncorporate, PastelNodeBlockEntity node, PastelNodeBlockEntity otherNode) {
        for (Map.Entry<PastelNodeType, Set<PastelNodeBlockEntity>> nodesToIncorporate : networkToIncorporate.loadedNodes.entrySet()) {
            for (PastelNodeBlockEntity nodeToIncorporate : nodesToIncorporate.getValue()) {
                this.addNode(nodeToIncorporate);
            }
        }
        networkToIncorporate.graph.vertexSet().forEach(pos -> {
            BlockEntity patt0$temp = ((ServerLevel)this.world).getBlockEntity(pos);
            if (patt0$temp instanceof PastelNodeBlockEntity) {
                PastelNodeBlockEntity switchNode = (PastelNodeBlockEntity)patt0$temp;
                switchNode.setNetworkUUID(this.uuid);
            }
            this.graph.addVertex(pos);
        });
        networkToIncorporate.graph.edgeSet().forEach(edge -> this.graph.addEdge((Object)((BlockPos)networkToIncorporate.getGraph().getEdgeSource(edge)), (Object)((BlockPos)networkToIncorporate.getGraph().getEdgeTarget(edge))));
        Pastel.getServerInstance().removeNetwork(networkToIncorporate.getUUID());
        this.addNode(node);
        this.addNode(otherNode);
        this.addEdge(node, otherNode);
        this.transmissionLogic.invalidateCache();
        PastelNetworkEdgeSyncPayload.send(this, node.getBlockPos());
    }

    @Override
    public boolean removeEdge(PastelNodeBlockEntity node, PastelNodeBlockEntity otherNode) {
        boolean success;
        Optional<ServerPastelNetwork> network = node.getServerNetwork();
        if (network.isEmpty()) {
            throw new IllegalStateException("Attempted to remove an edge from a null network");
        }
        Optional<ServerPastelNetwork> otherNetwork = otherNode.getServerNetwork();
        if (otherNetwork.isEmpty() || !network.get().equals(otherNetwork.get())) {
            throw new IllegalArgumentException("Can't remove an edge between nodes in different networks - how did you even do this");
        }
        boolean bl = success = this.graph.removeEdge((Object)node.getBlockPos(), (Object)otherNode.getBlockPos()) != null;
        if (success) {
            this.checkForNetworkSplit(node.getBlockPos());
            this.transmissionLogic.invalidateCache();
            PastelNetworkEdgeSyncPayload.send(this, node.getBlockPos());
        }
        return success;
    }

    protected void removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        if (!this.graph.containsVertex((Object)node.getBlockPos())) {
            return;
        }
        if (reason != NodeRemovalReason.UNLOADED) {
            this.graph.removeVertex((Object)node.getBlockPos());
        }
        this.loadedNodes.get((Object)node.getNodeType()).remove(node);
        this.removePriorityNode(node, node.getPriority());
        if (reason.checksForNetworkSplit) {
            this.checkForNetworkSplit(node.getBlockPos());
            PastelNetworkEdgeSyncPayload.send(this, node.getBlockPos());
        }
        if (reason != NodeRemovalReason.REMOVED) {
            node.setNetworkUUID(null);
        }
    }

    @Override
    public boolean addEdge(PastelNodeBlockEntity existingNode, PastelNodeBlockEntity newNode) {
        Optional<ServerPastelNetwork> network = existingNode.getServerNetwork();
        if (network.isEmpty()) {
            throw new IllegalStateException("Attempted to add an edge to a null network");
        }
        if (network.get() != this) {
            throw new IllegalStateException("Attempted to add an edge to a foreign network");
        }
        Optional<ServerPastelNetwork> otherNetwork = newNode.getServerNetwork();
        if (otherNetwork.isPresent() && !otherNetwork.equals(network)) {
            throw new IllegalArgumentException("Can't add an edge between nodes in different networks");
        }
        if (existingNode == newNode) {
            throw new IllegalStateException("Attempted to connect a node to itself");
        }
        if (network.get().hasEdge(existingNode.getBlockPos(), newNode.getBlockPos())) {
            throw new IllegalStateException("Attempted to add an edge that already exists");
        }
        this.addNode(newNode);
        return super.addEdge(existingNode, newNode);
    }

    public void markDirty(BlockPos syncPos) {
        this.transmissionLogic.invalidateCache();
        PastelNetworkEdgeSyncPayload.send(this, syncPos);
    }

    protected void tick() {
        this.transmissions.tick();
        PastelNetwork.NodePriority priority = PastelNetwork.NodePriority.GENERIC;
        if (this.transferLooper.getTick() % 5 == 0) {
            priority = PastelNetwork.NodePriority.MODERATE;
        } else if (this.transferLooper.getTick() % 2 == 0) {
            priority = PastelNetwork.NodePriority.HIGH;
        }
        this.transferLooper.tick();
        boolean cap = this.transferLooper.reachedCap();
        if (cap || priority != PastelNetwork.NodePriority.GENERIC) {
            if (cap) {
                this.transferLooper.reset();
            }
            try {
                this.transmissionLogic.tick(priority);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tickNodeEffects();
    }

    public Map<PastelTransmission, Integer> getTransmissions() {
        return this.transmissions.getMap();
    }

    private void tickNodeEffects() {
        ArrayList<PastelNodeBlockEntity> nodeSync = new ArrayList<PastelNodeBlockEntity>();
        for (Map.Entry<PastelTransmission, Integer> entry : this.transmissions) {
            BlockEntity node;
            int travelTime;
            double progress;
            PastelTransmission transmission = entry.getKey();
            Integer remainingTravelTime = entry.getValue();
            List<BlockPos> nodes = transmission.getNodePositions();
            if (nodes.isEmpty() || (progress = (double)((travelTime = transmission.getTransmissionDuration()) - remainingTravelTime)) == 0.0 || progress % (double)transmission.getVertexTime() != 0.0 || !((node = ((ServerLevel)this.world).getBlockEntity(nodes.get((int)Math.round((double)(nodes.size() - 1) * progress / (double)travelTime)))) instanceof PastelNodeBlockEntity)) continue;
            PastelNodeBlockEntity pastelNode = (PastelNodeBlockEntity)node;
            nodeSync.add(pastelNode);
            if (!pastelNode.isSensor()) continue;
            pastelNode.notifySensor();
        }
        if (!nodeSync.isEmpty()) {
            PastelNodeStatusUpdatePayload.sendPastelNodeStatusUpdate(nodeSync, false);
        }
    }

    public void addTransmission(PastelTransmission transmission, int travelTime) {
        transmission.setNetwork(this);
        this.transmissions.put(transmission, travelTime);
    }
}

