/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pastel_network.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.network.ServerPastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import earth.terrarium.pastel.helpers.data.SchedulerMap;
import earth.terrarium.pastel.helpers.interaction.InWorldInteractionHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelTransmission
implements SchedulerMap.Callback {
    public static final Codec<PastelTransmission> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockPos.CODEC.listOf().fieldOf("node_positions").forGetter(PastelTransmission::getNodePositions), (App)ItemStack.CODEC.fieldOf("variant").forGetter(PastelTransmission::getStack), (App)Codec.LONG.fieldOf("amount").forGetter(PastelTransmission::getAmount), (App)Codec.INT.fieldOf("vertex_time").forGetter(PastelTransmission::getVertexTime)).apply((Applicative)i, PastelTransmission::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PastelTransmission> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), PastelTransmission::getNodePositions, (StreamCodec)ItemStack.STREAM_CODEC, PastelTransmission::getStack, (StreamCodec)ByteBufCodecs.VAR_LONG, PastelTransmission::getAmount, (StreamCodec)ByteBufCodecs.VAR_INT, PastelTransmission::getVertexTime, PastelTransmission::new);
    @Nullable
    private ServerPastelNetwork network;
    private final List<BlockPos> nodePositions;
    private final ItemStack stack;
    private final long amount;
    private final int vertexTime;

    public PastelTransmission(List<BlockPos> nodePositions, ItemStack stack, long amount, int vertexTime) {
        this.nodePositions = nodePositions;
        this.stack = stack;
        this.amount = amount;
        this.vertexTime = vertexTime;
    }

    public void setNetwork(@NotNull ServerPastelNetwork network) {
        this.network = network;
    }

    @Nullable
    public PastelNetwork<ServerLevel> getNetwork() {
        return this.network;
    }

    public List<BlockPos> getNodePositions() {
        return this.nodePositions;
    }

    public int getVertexTime() {
        return this.vertexTime;
    }

    public int getTransmissionDuration() {
        return this.vertexTime * (this.nodePositions.size() - 1);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public long getAmount() {
        return this.amount;
    }

    public BlockPos getStartPos() {
        return this.nodePositions.get(0);
    }

    @Override
    public void trigger() {
        this.arriveAtDestination();
    }

    private void arriveAtDestination() {
        IItemHandler destinationHandler;
        if (this.nodePositions.isEmpty()) {
            return;
        }
        @NotNull BlockPos destinationPos = this.nodePositions.get(this.nodePositions.size() - 1);
        @Nullable PastelNodeBlockEntity destinationNode = this.network.getLoadedNodeAt(destinationPos);
        Object world = this.network.getLevel();
        long inserted = 0L;
        if (destinationNode != null && (destinationHandler = destinationNode.getConnectedHandler()) != null) {
            inserted = this.amount;
            inserted -= (long)ItemHandlerHelper.insertItemStacked((IItemHandler)destinationHandler, (ItemStack)this.stack.copyWithCount((int)this.amount), (boolean)false).getCount();
            destinationNode.addItemCountUnderway(-this.amount);
        }
        if (inserted != this.amount) {
            InWorldInteractionHelper.scatter(world, (double)destinationPos.getX() + 0.5, (double)destinationPos.getY() + 0.5, (double)destinationPos.getZ() + 0.5, this.stack, this.amount - inserted);
        }
    }
}

