/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.pastel_network.network;

import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.pastel.blocks.pastel_network.PastelRenderHelper;
import earth.terrarium.pastel.blocks.pastel_network.network.ClientPastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.network.PastelNetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Clearable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class ClientPastelNetworkManager
implements PastelNetworkManager<ClientLevel, ClientPastelNetwork>,
Clearable {
    protected static final int MAX_RENDER_DISTANCE_SQUARED = 2304;
    private final List<ClientPastelNetwork> networks = new ArrayList<ClientPastelNetwork>();

    @Override
    public Optional<? extends ClientPastelNetwork> getNetwork(UUID uuid) {
        return this.networks.stream().filter(n -> n.uuid.equals(uuid)).findFirst();
    }

    @Override
    public ClientPastelNetwork createNetwork(ClientLevel level, UUID uuid, int color) {
        ClientPastelNetwork network = new ClientPastelNetwork(level, uuid, color);
        this.networks.add(network);
        return network;
    }

    public void renderLines(ClientLevel level, PoseStack matrices, MultiBufferSource bufferSource, Camera camera) {
        Vec3 pos = camera.getPosition();
        BlockPos blockPos = camera.getBlockPosition();
        long worldTime = level.getGameTime();
        for (ClientPastelNetwork network : this.networks) {
            if (((ClientLevel)network.getLevel()).dimensionType() != level.dimensionType()) continue;
            Graph<BlockPos, DefaultEdge> graph = network.getGraph();
            int color = network.getColor();
            float[] colors = PastelRenderHelper.unpackNormalizedColor(color);
            for (DefaultEdge edge : graph.edgeSet()) {
                BlockPos source = (BlockPos)graph.getEdgeSource((Object)edge);
                BlockPos target = (BlockPos)graph.getEdgeTarget((Object)edge);
                if (blockPos.distSqr((Vec3i)source) > 2304.0 && blockPos.distSqr((Vec3i)target) > 2304.0) continue;
                matrices.pushPose();
                matrices.translate(-pos.x, -pos.y, -pos.z);
                BlockPos cross = source.cross((Vec3i)target);
                float interval = (float)((long)(cross.getX() + cross.getY() + cross.getZ()) + worldTime) % 1000000.0f;
                double alpha = 1.0 - Math.max((double)((double)Math.sin((float)(interval / 17.0f)) * 2.5 - 2.0), (double)0.0);
                colors[0] = (float)alpha;
                PastelRenderHelper.renderLineTo(matrices, bufferSource, colors, source, target);
                matrices.popPose();
            }
        }
    }

    public void clearContent() {
        this.networks.clear();
    }

    @Override
    public void removeNetwork(UUID uuid) {
        ClientPastelNetwork foundNetwork = null;
        for (ClientPastelNetwork network : this.networks) {
            if (!network.uuid.equals(uuid)) continue;
            foundNetwork = network;
            break;
        }
        if (foundNetwork != null) {
            this.networks.remove(foundNetwork);
        }
    }
}

