/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.particle_spawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.particle.effect.DynamicParticleEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record ParticleSpawnerConfiguration(ParticleType<?> particleType, Vec3i cmyColor, boolean glowing, float particlesPerSecond, Vec3 sourcePosition, Vec3 sourcePositionVariance, Vec3 velocity, Vec3 velocityVariance, float scale, float scaleVariance, int lifetimeTicks, int lifetimeVariance, float gravity, boolean collisions) {
    public static final Codec<ParticleSpawnerConfiguration> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.PARTICLE_TYPE.byNameCodec().fieldOf("particle_type_identifier").forGetter(ParticleSpawnerConfiguration::particleType), (App)Vec3i.CODEC.fieldOf("color").forGetter(ParticleSpawnerConfiguration::cmyColor), (App)Codec.BOOL.fieldOf("glowing").forGetter(ParticleSpawnerConfiguration::glowing), (App)Codec.FLOAT.fieldOf("particles_per_tick").forGetter(ParticleSpawnerConfiguration::particlesPerSecond), (App)Vec3.CODEC.fieldOf("source_pos").forGetter(ParticleSpawnerConfiguration::sourcePosition), (App)Vec3.CODEC.fieldOf("source_pos_variance").forGetter(ParticleSpawnerConfiguration::sourcePositionVariance), (App)Vec3.CODEC.fieldOf("source_velocity").forGetter(ParticleSpawnerConfiguration::velocity), (App)Vec3.CODEC.fieldOf("source_velocity_variance").forGetter(ParticleSpawnerConfiguration::velocityVariance), (App)Codec.FLOAT.fieldOf("scale").forGetter(ParticleSpawnerConfiguration::scale), (App)Codec.FLOAT.fieldOf("scale_variance").forGetter(ParticleSpawnerConfiguration::scaleVariance), (App)Codec.INT.fieldOf("lifetime").forGetter(ParticleSpawnerConfiguration::lifetimeTicks), (App)Codec.INT.fieldOf("lifetime_variance").forGetter(ParticleSpawnerConfiguration::lifetimeVariance), (App)Codec.FLOAT.fieldOf("gravity").forGetter(ParticleSpawnerConfiguration::gravity), (App)Codec.BOOL.fieldOf("collisions").forGetter(ParticleSpawnerConfiguration::collisions)).apply((Applicative)i, ParticleSpawnerConfiguration::new));
    public static final StreamCodec<FriendlyByteBuf, ParticleSpawnerConfiguration> STREAM_CODEC = PacketCodecHelper.tuple(PacketCodecHelper.registryValueByName(BuiltInRegistries.PARTICLE_TYPE), c -> c.particleType, PacketCodecHelper.VEC3I, c -> c.cmyColor, ByteBufCodecs.BOOL, c -> c.glowing, ByteBufCodecs.FLOAT, c -> Float.valueOf(c.particlesPerSecond), PacketCodecHelper.VEC3D, c -> c.sourcePosition, PacketCodecHelper.VEC3D, c -> c.sourcePositionVariance, PacketCodecHelper.VEC3D, c -> c.velocity, PacketCodecHelper.VEC3D, c -> c.velocityVariance, ByteBufCodecs.FLOAT, c -> Float.valueOf(c.scale), ByteBufCodecs.FLOAT, c -> Float.valueOf(c.scaleVariance), ByteBufCodecs.VAR_INT, c -> c.lifetimeTicks, ByteBufCodecs.VAR_INT, c -> c.lifetimeVariance, ByteBufCodecs.FLOAT, c -> Float.valueOf(c.gravity), ByteBufCodecs.BOOL, c -> c.collisions, ParticleSpawnerConfiguration::new);

    public static Vector3fc CMYtoRGB(Vec3i cmy) {
        float r = 1.0f - (float)cmy.getX() / 100.0f;
        float g = 1.0f - (float)cmy.getY() / 100.0f;
        float b = 1.0f - (float)cmy.getZ() / 100.0f;
        return new Vector3f(r, g, b);
    }

    public void spawnParticles(Level world, @NotNull BlockPos pos) {
        for (float particlesToSpawn = this.particlesPerSecond / 20.0f; particlesToSpawn >= 1.0f || world.random.nextFloat() < particlesToSpawn; particlesToSpawn -= 1.0f) {
            this.spawnParticle(world, pos, world.random);
        }
    }

    private void spawnParticle(Level world, @NotNull BlockPos pos, RandomSource random) {
        int randomLifetime;
        float randomScale = this.scaleVariance == 0.0f ? this.scale : (float)((double)(this.scale + this.scaleVariance) - random.nextDouble() * (double)this.scaleVariance * 2.0);
        int n = randomLifetime = this.lifetimeVariance == 0 ? this.lifetimeTicks : (int)((double)(this.lifetimeTicks + this.lifetimeVariance) - random.nextDouble() * (double)this.lifetimeVariance * 2.0);
        if (randomScale > 0.0f && randomLifetime > 0) {
            double randomOffsetX = this.sourcePositionVariance.x == 0.0 ? 0.0 : this.sourcePositionVariance.x - random.nextDouble() * this.sourcePositionVariance.x * 2.0;
            double randomOffsetY = this.sourcePositionVariance.y == 0.0 ? 0.0 : this.sourcePositionVariance.y - random.nextDouble() * this.sourcePositionVariance.y * 2.0;
            double randomOffsetZ = this.sourcePositionVariance.z == 0.0 ? 0.0 : this.sourcePositionVariance.z - random.nextDouble() * this.sourcePositionVariance.z * 2.0;
            double randomVelocityX = this.velocityVariance.x == 0.0 ? 0.0 : this.velocityVariance.x - random.nextDouble() * this.velocityVariance.x * 2.0;
            double randomVelocityY = this.velocityVariance.y == 0.0 ? 0.0 : this.velocityVariance.y - random.nextDouble() * this.velocityVariance.y * 2.0;
            double randomVelocityZ = this.velocityVariance.z == 0.0 ? 0.0 : this.velocityVariance.z - random.nextDouble() * this.velocityVariance.z * 2.0;
            Vector3fc rgbColor = ParticleSpawnerConfiguration.CMYtoRGB(this.cmyColor);
            world.addParticle((ParticleOptions)new DynamicParticleEffect(this.particleType, this.gravity, new Vector3f(rgbColor), randomScale, randomLifetime, this.collisions, this.glowing), (double)pos.getX() + 0.5 + this.sourcePosition.x + randomOffsetX, (double)pos.getY() + 0.5 + this.sourcePosition.y + randomOffsetY, (double)pos.getZ() + 0.5 + this.sourcePosition.z + randomOffsetZ, this.velocity.x + randomVelocityX, this.velocity.y + randomVelocityY, this.velocity.z + randomVelocityZ);
        }
    }
}

