/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.particle_spawner;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import earth.terrarium.pastel.blocks.particle_spawner.AbstractParticleSpawnerBlock;
import earth.terrarium.pastel.blocks.particle_spawner.ParticleSpawnerConfiguration;
import earth.terrarium.pastel.inventories.ParticleSpawnerScreenHandler;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ParticleSpawnerBlockEntity
extends BlockEntity
implements MenuProvider {
    protected ParticleSpawnerConfiguration configuration = new ParticleSpawnerConfiguration((ParticleType<?>)PastelParticleTypes.SHOOTING_STAR, new Vec3i(80, 40, 0), false, 10.0f, new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.1, 0.0), new Vec3(0.1, 0.1, 0.1), 1.0f, 0.2f, 20, 10, 0.02f, true);
    protected boolean initialized = false;

    public ParticleSpawnerBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType<ParticleSpawnerBlockEntity>)((BlockEntityType)PastelBlockEntities.PARTICLE_SPAWNER.get()), blockPos, blockState);
    }

    public ParticleSpawnerBlockEntity(BlockEntityType<ParticleSpawnerBlockEntity> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, ParticleSpawnerBlockEntity blockEntity) {
        AbstractParticleSpawnerBlock particleSpawnerBlock;
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof AbstractParticleSpawnerBlock && (particleSpawnerBlock = (AbstractParticleSpawnerBlock)block).shouldSpawnParticles(world, pos)) {
            blockEntity.configuration.spawnParticles(world, pos);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbtCompound = new CompoundTag();
        this.saveAdditional(nbtCompound, registryLookup);
        return nbtCompound;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void updateInClientWorld() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 4);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        tag.put("particle_config", (Tag)ParticleSpawnerConfiguration.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.configuration).result().orElse(new CompoundTag()));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        this.initialized = false;
        Optional config = ParticleSpawnerConfiguration.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("particle_config")).result();
        if (config.isPresent()) {
            this.configuration = (ParticleSpawnerConfiguration)((Pair)config.get()).getFirst();
            this.initialized = true;
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new ParticleSpawnerScreenHandler(syncId, inv, this);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.pastel.particle_spawner");
    }

    public void applySettings(ParticleSpawnerConfiguration configuration) {
        this.configuration = configuration;
        this.initialized = true;
        this.updateInClientWorld();
        this.setChanged();
    }

    public ParticleSpawnerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.worldPosition);
    }
}

