/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.particle_spawner;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.api.block.RedstonePoweredBlock;
import earth.terrarium.pastel.blocks.particle_spawner.AbstractParticleSpawnerBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ParticleSpawnerBlock
extends AbstractParticleSpawnerBlock
implements RedstonePoweredBlock {
    public static final MapCodec<ParticleSpawnerBlock> CODEC = ParticleSpawnerBlock.simpleCodec(ParticleSpawnerBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0);

    public ParticleSpawnerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends ParticleSpawnerBlock> codec() {
        return CODEC;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.particle_spawner.tooltip").withStyle(ChatFormatting.GRAY));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.POWERED});
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (!world.isClientSide) {
            if (this.checkGettingPowered(world, pos)) {
                this.power(world, pos);
            } else {
                this.unPower(world, pos);
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState placementState = this.defaultBlockState();
        if (ctx.getLevel().getBestNeighborSignal(ctx.getClickedPos()) > 0) {
            placementState = (BlockState)placementState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true));
        }
        return placementState;
    }

    @Override
    public boolean shouldSpawnParticles(Level world, BlockPos pos) {
        return ((Boolean)world.getBlockState(pos).getValue((Property)BlockStateProperties.POWERED)).equals(true);
    }
}

