/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.mob_head.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.blocks.mob_head.client.PastelSkullModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TropicalFishHeadModel
extends PastelSkullModel {
    private static final ResourceLocation PATTERN_TEXTURE = ResourceLocation.parse((String)"textures/entity/fish/tropical_a_pattern_1.png");
    protected final ModelPart pattern;

    public TropicalFishHeadModel(ModelPart root, ModelPart pattern) {
        super(root);
        this.pattern = pattern.getChild("head");
    }

    public static MeshDefinition getModelData(CubeDeformation dilation) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition head = modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -3.0f, -3.0f, 2.0f, 3.0f, 6.0f, dilation), PartPose.ZERO);
        head.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(22, -6).addBox(0.0f, -3.0f, 3.0f, 0.0f, 3.0f, 6.0f, dilation), PartPose.ZERO);
        head.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(2, 16).addBox(-2.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, dilation), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        head.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(2, 12).addBox(0.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, dilation), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        head.addOrReplaceChild("top_fin", CubeListBuilder.create().texOffs(10, -5).addBox(0.0f, -6.0f, -3.0f, 0.0f, 3.0f, 6.0f, dilation), PartPose.ZERO);
        return modelData;
    }

    public static LayerDefinition getTexturedModelData() {
        return LayerDefinition.create((MeshDefinition)TropicalFishHeadModel.getModelData(CubeDeformation.NONE), (int)32, (int)32);
    }

    public static LayerDefinition getTexturedModelDataPattern() {
        return LayerDefinition.create((MeshDefinition)TropicalFishHeadModel.getModelData(new CubeDeformation(0.008f)), (int)32, (int)32);
    }

    @Override
    public void setupAnim(float animationProgress, float yaw, float pitch) {
        super.setupAnim(animationProgress, yaw, pitch);
        this.pattern.yRot = yaw * ((float)Math.PI / 180);
        this.pattern.xRot = pitch * ((float)Math.PI / 180);
    }

    @Override
    public void render(PoseStack matrices, VertexConsumer vertices, MultiBufferSource vertexConsumerProvider, int light, int overlay, int argb) {
        float scale = this.getScale();
        matrices.scale(scale, scale, scale);
        int alpha = FastColor.ARGB32.alpha((int)argb);
        int red = FastColor.ARGB32.color((int)alpha, (int)DyeColor.RED.getTextureDiffuseColor());
        this.renderToBuffer(matrices, vertices, light, overlay, red);
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.entityCutoutNoCullZOffset((ResourceLocation)PATTERN_TEXTURE));
        int blue = FastColor.ARGB32.color((int)alpha, (int)DyeColor.BLUE.getTextureDiffuseColor());
        this.pattern.render(matrices, vertexConsumer, light, overlay, blue);
    }
}

