/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.mob_head.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.mob_head.client.PastelSkullModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LizardHeadModel
extends PastelSkullModel {
    public static final ResourceLocation HEAD_TEXTURE = PastelCommon.locate("textures/entity/lizard/lizard_head.png");
    protected final int color;
    protected final ModelPart frills;

    public LizardHeadModel(ModelPart root, ModelPart frills, int color) {
        super(root);
        this.color = color;
        this.frills = frills;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition head = modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(11, 58).addBox(-2.5f, -6.0f, 1.0f, 5.0f, 6.0f, 5.0f).texOffs(44, 44).addBox(-2.0f, -6.0f, -8.0f, 4.0f, 3.0f, 9.0f).texOffs(26, 21).addBox(0.0f, -13.0f, -9.0f, 0.0f, 8.0f, 15.0f), PartPose.ZERO);
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(61, 0).addBox(-1.5f, 0.0f, -5.5f, 3.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public static LayerDefinition getTexturedModelDataFrills() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition head = modelPartData.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.ZERO);
        head.addOrReplaceChild("rightfrills_r1", CubeListBuilder.create().texOffs(61, 40).addBox(-1.9733f, -9.9307f, 0.0f, 8.0f, 10.0f, 0.0f), PartPose.offsetAndRotation((float)2.5f, (float)-6.0f, (float)1.0f, (float)-0.8281f, (float)0.001f, (float)1.5679f));
        head.addOrReplaceChild("leftfrills_r1", CubeListBuilder.create().texOffs(45, 68).addBox(-6.0267f, -9.9307f, 0.0f, 8.0f, 10.0f, 0.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-6.0f, (float)1.0f, (float)-0.8282f, (float)0.0f, (float)-1.5615f));
        head.addOrReplaceChild("topfrills_r1", CubeListBuilder.create().texOffs(60, 56).addBox(-4.5f, -11.75f, -0.15f, 9.0f, 12.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)1.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(61, 0).addBox(-1.5f, 0.0f, -5.5f, 3.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    @Override
    public void setupAnim(float animationProgress, float yaw, float pitch) {
        super.setupAnim(animationProgress, yaw, pitch);
        this.frills.yRot = yaw * ((float)Math.PI / 180);
        this.frills.xRot = pitch * ((float)Math.PI / 180);
    }

    @Override
    public void render(PoseStack matrices, VertexConsumer vertices, MultiBufferSource vertexConsumerProvider, int light, int overlay, int argb) {
        float scale = this.getScale();
        matrices.scale(scale, scale, scale);
        this.renderToBuffer(matrices, vertices, light, overlay, argb);
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.entityCutoutNoCullZOffset((ResourceLocation)HEAD_TEXTURE));
        int alpha = FastColor.ARGB32.alpha((int)argb);
        this.frills.render(matrices, vertexConsumer, light, overlay, FastColor.ARGB32.color((int)alpha, (int)this.color));
    }
}

