/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.lava_sponge;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;

public class WetLavaSpongeItem
extends BlockItem {
    public WetLavaSpongeItem(Block block, Item.Properties itemSettings) {
        super(block, itemSettings);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world != null && entity != null) {
            if (world.isClientSide) {
                RandomSource random = world.getRandom();
                if (random.nextInt(50) == 0) {
                    entity.playSound(SoundEvents.FIRE_EXTINGUISH, 0.4f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.2f);
                }
            } else {
                int r = world.getRandom().nextInt(120);
                if (r < 2) {
                    entity.setRemainingFireTicks(25);
                } else if (r < 3 && world.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
                    RandomSource random = world.getRandom();
                    int xOffset = 3 - random.nextInt(7);
                    int yOffset = 1 - random.nextInt(3);
                    int zOffset = 3 - random.nextInt(7);
                    BlockPos targetPos = BlockPos.containing((Position)entity.position()).offset(xOffset, yOffset, zOffset);
                    if (BaseFireBlock.canBePlacedAt((Level)world, (BlockPos)targetPos, (Direction)Direction.UP)) {
                        world.setBlockAndUpdate(targetPos, BaseFireBlock.getState((BlockGetter)world, (BlockPos)targetPos));
                    }
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.wet_lava_sponge.tooltip"));
    }
}

