/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.lava_sponge;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WetSpongeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WetLavaSpongeBlock
extends WetSpongeBlock {
    public static final MapCodec<WetLavaSpongeBlock> CODEC = WetLavaSpongeBlock.simpleCodec(WetLavaSpongeBlock::new);

    public WetLavaSpongeBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    private static int getRandomTickTime(Level world) {
        if (world.dimensionType().ultraWarm()) {
            return 10 + world.random.nextInt(5);
        }
        return 20 + world.random.nextInt(10);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int zOffset;
        int yOffset;
        int xOffset;
        BlockPos targetPos;
        world.scheduleTick(pos, (Block)this, WetLavaSpongeBlock.getRandomTickTime((Level)world));
        if (world.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK) && BaseFireBlock.canBePlacedAt((Level)world, (BlockPos)(targetPos = pos.offset(xOffset = 2 - random.nextInt(5), yOffset = 1 - random.nextInt(3), zOffset = 2 - random.nextInt(5))), (Direction)Direction.UP)) {
            world.setBlockAndUpdate(targetPos, BaseFireBlock.getState((BlockGetter)world, (BlockPos)targetPos));
        }
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        world.scheduleTick(pos, (Block)this, WetLavaSpongeBlock.getRandomTickTime(world));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Direction direction = Direction.getRandom((RandomSource)random);
        if (direction != Direction.UP) {
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState = world.getBlockState(blockPos);
            if (!state.canOcclude() || !blockState.isFaceSturdy((BlockGetter)world, blockPos, direction.getOpposite())) {
                double d = pos.getX();
                double e = pos.getY();
                double f = pos.getZ();
                if (direction == Direction.DOWN) {
                    e -= 0.05;
                    d += random.nextDouble();
                    f += random.nextDouble();
                } else {
                    e += random.nextDouble() * 0.8;
                    if (direction.getAxis() == Direction.Axis.X) {
                        f += random.nextDouble();
                        d = direction == Direction.EAST ? (d += 1.0) : (d += 0.05);
                    } else {
                        d += random.nextDouble();
                        f = direction == Direction.SOUTH ? (f += 1.0) : (f += 0.05);
                    }
                }
                world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_LAVA, d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }
}

