/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.lava_sponge;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SpongeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class LavaSpongeBlock
extends SpongeBlock {
    public static final MapCodec<LavaSpongeBlock> CODEC = LavaSpongeBlock.simpleCodec(LavaSpongeBlock::new);

    public LavaSpongeBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected void tryAbsorbWater(Level world, BlockPos pos) {
        if (this.absorbLava(world, pos)) {
            world.setBlock(pos, ((Block)PastelBlocks.WET_LAVA_SPONGE.get()).defaultBlockState(), 2);
            world.playSound(null, pos, SoundEvents.SPONGE_ABSORB, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean absorbLava(Level world, BlockPos pos) {
        return BlockPos.breadthFirstTraversal((BlockPos)pos, (int)12, (int)512, (currentPos, queuer) -> {
            for (Direction direction : Direction.values()) {
                queuer.accept(currentPos.relative(direction));
            }
        }, currentPos -> {
            BucketPickup fluidDrainable;
            if (currentPos.equals((Object)pos)) {
                return true;
            }
            BlockState blockState = world.getBlockState(currentPos);
            FluidState fluidState = world.getFluidState(currentPos);
            if (!fluidState.is(FluidTags.LAVA)) {
                return false;
            }
            Block block = blockState.getBlock();
            if (block instanceof BucketPickup && !(fluidDrainable = (BucketPickup)block).pickupBlock(null, (LevelAccessor)world, currentPos, blockState).isEmpty()) {
                return true;
            }
            if (blockState.getBlock() instanceof LiquidBlock) {
                world.setBlock(currentPos, Blocks.AIR.defaultBlockState(), 3);
            }
            return true;
        }) > 1;
    }
}

