/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.jade_vines;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.jade_vines.StemComponent;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class NephriteBlossomStemBlock
extends BushBlock {
    public static final MapCodec<NephriteBlossomStemBlock> CODEC = NephriteBlossomStemBlock.simpleCodec(NephriteBlossomStemBlock::new);
    public static final EnumProperty<StemComponent> STEM_PART = StemComponent.PROPERTY;

    public NephriteBlossomStemBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(STEM_PART, (Comparable)((Object)StemComponent.BASE)));
    }

    public MapCodec<? extends NephriteBlossomStemBlock> codec() {
        return CODEC;
    }

    public static BlockState getStemVariant(boolean top) {
        return (BlockState)((Block)PastelBlocks.NEPHRITE_BLOSSOM_STEM.get()).defaultBlockState().setValue(STEM_PART, (Comparable)((Object)(top ? StemComponent.STEMALT : StemComponent.STEM)));
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (handStack.is(Tags.Items.TOOLS_SHEAR) && state.getValue(STEM_PART) == StemComponent.BASE) {
            BlockState newState = (BlockState)state.setValue(STEM_PART, (Comparable)((Object)StemComponent.STEM));
            world.setBlockAndUpdate(pos, newState);
            player.playNotifySound(SoundEvents.MOOSHROOM_SHEAR, SoundSource.BLOCKS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            handStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return super.useItemOn(handStack, state, world, pos, player, hand, hit);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState floor = world.getBlockState(pos.below());
        BlockState state = super.getStateForPlacement(ctx);
        if (state == null) {
            return null;
        }
        if (floor.is((Block)this)) {
            if (floor.getValue(STEM_PART) != StemComponent.STEMALT) {
                state = (BlockState)state.setValue(STEM_PART, (Comparable)((Object)StemComponent.STEMALT));
            } else if (floor.getValue(STEM_PART) != StemComponent.STEM) {
                state = (BlockState)state.setValue(STEM_PART, (Comparable)((Object)StemComponent.STEM));
            }
        }
        return state;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is((Block)this) || super.mayPlaceOn(floor, world, pos);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(state, world, pos, random);
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STEM_PART});
    }
}

