/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.jade_vines;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelConfiguredFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;

public class JadeiteLotusBulbBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<JadeiteLotusBulbBlock> CODEC = JadeiteLotusBulbBlock.simpleCodec(JadeiteLotusBulbBlock::new);

    public JadeiteLotusBulbBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends JadeiteLotusBulbBlock> codec() {
        return CODEC;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.mayPlaceOn(world.getBlockState(pos.above()), (BlockGetter)world, pos.above());
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if ((double)random.nextFloat() < 0.025) {
            this.performBonemeal(world, random, pos, state);
        }
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return super.mayPlaceOn(floor, world, pos) || floor.is(PastelBlockTags.BASE_STONE_DEEPER_DOWN);
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        ((ConfiguredFeature)world.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).get(PastelConfiguredFeatures.JADEITE_LOTUS)).place((WorldGenLevel)world, world.getChunkSource().getGenerator(), random, pos);
    }
}

