/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.jade_vines;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.api.interaction.NaturesStaffTriggered;
import earth.terrarium.pastel.blocks.jade_vines.JadeVine;
import earth.terrarium.pastel.blocks.jade_vines.JadeVineRootsBlock;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelLootTables;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeVinePlantBlock
extends Block
implements JadeVine,
NaturesStaffTriggered {
    public static final MapCodec<JadeVinePlantBlock> CODEC = JadeVinePlantBlock.simpleCodec(JadeVinePlantBlock::new);
    public static final EnumProperty<JadeVinesPlantPart> PART = EnumProperty.create((String)"part", JadeVinesPlantPart.class);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;

    public JadeVinePlantBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)JadeVinesPlantPart.BASE))).setValue((Property)AGE, (Comparable)Integer.valueOf(1)));
    }

    public MapCodec<? extends JadeVinePlantBlock> codec() {
        return CODEC;
    }

    public static List<ItemStack> getHarvestedStacks(BlockState state, ServerLevel world, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, ItemStack stack, ResourceKey<LootTable> lootTableIdentifier) {
        LootParams.Builder builder = new LootParams.Builder(world).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)stack).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)entity).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
        LootTable lootTable = world.getServer().reloadableRegistries().getLootTable(lootTableIdentifier);
        return lootTable.getRandomItems(builder.create(LootContextParamSets.BLOCK));
    }

    static void setHarvested(@NotNull BlockState blockState, @NotNull ServerLevel world, @NotNull BlockPos blockPos) {
        BlockPos rootsPos = ((JadeVinesPlantPart)((Object)blockState.getValue(PART))).getLowestRootsPos(blockPos);
        Block block = world.getBlockState(rootsPos).getBlock();
        if (block instanceof JadeVineRootsBlock) {
            JadeVineRootsBlock jadeVineRootsBlock = (JadeVineRootsBlock)block;
            jadeVineRootsBlock.setPlantToAge(world, rootsPos, 1);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        int age = (Integer)state.getValue((Property)AGE);
        if (age == 7) {
            if ((double)random.nextFloat() < 0.3) {
                JadeVine.spawnBloomParticlesClient(world, pos);
            }
        } else if (age != 0) {
            JadeVine.spawnParticlesClient(world, pos);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos) || this.missingBottom(state, world.getBlockState(pos.below()))) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos) || this.missingBottom(state, world.getBlockState(pos.below()))) {
            world.destroyBlock(pos, false);
        }
    }

    private boolean missingBottom(BlockState state, BlockState belowState) {
        JadeVinesPlantPart part = (JadeVinesPlantPart)((Object)state.getValue(PART));
        if (part == JadeVinesPlantPart.TIP) {
            return false;
        }
        return !(belowState.getBlock() instanceof JadeVinePlantBlock);
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        JadeVinesGrowthStage growthStage = JadeVinesGrowthStage.fromAge((Integer)state.getValue((Property)AGE));
        if (growthStage.isFullyGrown()) {
            boolean harvested = false;
            if (handStack.is(Items.GLASS_BOTTLE)) {
                if (world.isClientSide) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayerEntity, pos, handStack);
                }
                handStack.shrink(1);
                JadeVinePlantBlock.setHarvested(state, (ServerLevel)world, pos);
                List<ItemStack> harvestedStacks = JadeVinePlantBlock.getHarvestedStacks(state, (ServerLevel)world, pos, world.getBlockEntity(pos), (Entity)player, handStack, PastelLootTables.JADE_VINE_HARVESTING_NECTAR);
                for (ItemStack harvestedStack : harvestedStacks) {
                    player.getInventory().placeItemBackInInventory(harvestedStack);
                }
                harvested = true;
            }
            if (!harvested) {
                player.displayClientMessage((Component)Component.translatable((String)"message.pastel.needs_item_to_harvest").append(Items.GLASS_BOTTLE.getDescription()), true);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        if (growthStage.canHarvestPetals()) {
            if (!world.isClientSide) {
                JadeVinePlantBlock.setHarvested(state, (ServerLevel)world, pos);
                List<ItemStack> harvestedStacks = JadeVinePlantBlock.getHarvestedStacks(state, (ServerLevel)world, pos, world.getBlockEntity(pos), (Entity)player, player.getMainHandItem(), PastelLootTables.JADE_VINE_HARVESTING_PETALS);
                for (ItemStack harvestedStack : harvestedStacks) {
                    player.getInventory().placeItemBackInInventory(harvestedStack);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(handStack, state, world, pos, player, hand, hit);
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return ((Item)PastelItems.GERMINATED_JADE_VINE_BULB.get()).getDefaultInstance();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.getValue(PART) == JadeVinesPlantPart.TIP ? TIP_SHAPE : SHAPE;
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader world, BlockPos pos) {
        BlockState upState = world.getBlockState(pos.above());
        Block upBlock = upState.getBlock();
        JadeVinesPlantPart part = (JadeVinesPlantPart)((Object)state.getValue(PART));
        if (part == JadeVinesPlantPart.BASE) {
            return upBlock instanceof JadeVineRootsBlock;
        }
        if (part == JadeVinesPlantPart.MIDDLE) {
            return upBlock instanceof JadeVinePlantBlock && upState.getValue(PART) == JadeVinesPlantPart.BASE;
        }
        return upBlock instanceof JadeVinePlantBlock && upState.getValue(PART) == JadeVinesPlantPart.MIDDLE;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, AGE});
    }

    @Override
    public boolean setToAge(Level world, BlockPos blockPos, int age) {
        int currentAge;
        BlockState currentState = world.getBlockState(blockPos);
        if (currentState.getBlock() instanceof JadeVinePlantBlock && age != (currentAge = ((Integer)currentState.getValue((Property)AGE)).intValue())) {
            world.setBlockAndUpdate(blockPos, (BlockState)currentState.setValue((Property)AGE, (Comparable)Integer.valueOf(age)));
            return true;
        }
        return false;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide && !player.isCreative()) {
            JadeVinePlantBlock.dropResources((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.playerDestroy(world, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, stack);
    }

    @Override
    public boolean canUseNaturesStaff(Level world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) == 0;
    }

    @Override
    public boolean onNaturesStaffUse(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos rootsPos = ((JadeVinesPlantPart)((Object)state.getValue(PART))).getLowestRootsPos(pos);
        BlockState rootsState = world.getBlockState(rootsPos);
        Block block = rootsState.getBlock();
        if (block instanceof JadeVineRootsBlock) {
            JadeVineRootsBlock jadeVineRootsBlock = (JadeVineRootsBlock)block;
            jadeVineRootsBlock.onNaturesStaffUse(world, rootsPos, rootsState, player);
        }
        JadeVine.spawnParticlesServer((ServerLevel)world, pos, 16);
        return false;
    }

    public static enum JadeVinesPlantPart implements StringRepresentable
    {
        BASE,
        MIDDLE,
        TIP;


        @Contract(pure=true)
        @NotNull
        public String toString() {
            return this.getSerializedName();
        }

        @Contract(pure=true)
        @NotNull
        public String getSerializedName() {
            return this == BASE ? "base" : (this == MIDDLE ? "middle" : "tip");
        }

        public BlockPos getLowestRootsPos(BlockPos blockPos) {
            if (this == BASE) {
                return blockPos.above();
            }
            if (this == MIDDLE) {
                return blockPos.above(2);
            }
            return blockPos.above(3);
        }
    }

    public static enum JadeVinesGrowthStage {
        DEAD,
        LEAVES,
        PETALS,
        BLOOM;


        public static JadeVinesGrowthStage fromAge(int age) {
            if (age == 0) {
                return DEAD;
            }
            if (age == 7) {
                return BLOOM;
            }
            if (age > 2) {
                return PETALS;
            }
            return LEAVES;
        }

        public static boolean isFullyGrown(int age) {
            return age == 7;
        }

        public boolean isFullyGrown() {
            return this == BLOOM;
        }

        public boolean canHarvestPetals() {
            return this == PETALS || this == BLOOM;
        }
    }
}

